<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token, apikey');
    header('Accept: multipart/form-data');
    header('Accept: application/json');
    include_once dirname(__FILE__) . '/../controller/response.controller.php';
    include_once dirname(__FILE__) . '/../controller/user.controller.php';
    include_once dirname(__FILE__) . '/../controller/departamento.controller.php';
    include_once dirname(__FILE__) . '/../controller/permiso.controller.php';
    include_once dirname(__FILE__) . '/../controller/marcaje.controller.php';
    include_once dirname(__FILE__) . '/../controller/sucursal.controller.php';
    include_once dirname(__FILE__) . '/../controller/firmante.controller.php';
    include_once dirname(__FILE__) . '/../controller/horaextra.controller.php';
    include_once dirname(__FILE__) . '/../controller/cargo.controller.php';
    include_once dirname(__FILE__) . '/../controller/turno.controller.php';
    include_once dirname(__FILE__) . '/../controller/mensaje.controller.php';
    include_once dirname(__FILE__) . '/../controller/perfil.controller.php';
    include_once dirname(__FILE__) . '/../controller/nacionalidad.controller.php';
    include_once dirname(__FILE__) . '/../controller/reloj.controller.php';
    include_once dirname(__FILE__) . '/../controller/empresa.controller.php';
    include_once dirname(__FILE__) . '/../controller/justificacion.controller.php';

    if ($_SERVER['REQUEST_METHOD'] == "OPTIONS") {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Origin, Content-Type, X-Requested-With, apikey');
        header('Accept: application/json');
        header("HTTP/1.1 200 OK");
        die();
    }

    $_responseController = new ResponseController;
    $_userController = new UserController;
    $_deptoController = new DepartamentoController;
    $_permisoController = new PermisoController;
    $_marcajeController = new MarcajeController;
    $_sucursalController = new SucursalController;
    $_firmanteController = new FirmanteController;
    $_horaExtraController = new HoraExtraController;
    $_cargoController = new CargoController;
    $_turnoController = new TurnoController;
    $_mensajeController = new MensajeController;
    $_perfilController = new PerfilController;
    $_nacionalidadController = new NacionalidadController;
    $_relojController = new RelojController;
    $_empresaController = new EmpresaController;
    $_justificacionController = new JustificacionController;

    $uriContent = @end(explode("public/", $_SERVER['REQUEST_URI']));
    if ($_SERVER['REQUEST_METHOD'] == "GET") {
        //RUTAS GET
        if (isset($uriContent) && $uriContent != "") {
            
        } else print_r(json_encode($_responseController->error_404()));
    } elseif ($_SERVER['REQUEST_METHOD'] == "POST") {
        //RUTAS POST
        $reqBody = file_get_contents("php://input");
        if (isset($uriContent) && $uriContent != "") {
            switch ($uriContent) {
                //PERSONAS
                case 'iniciarsesion':
                    print_r(json_encode($_userController->logIn($reqBody)));
                    break;
                    
                case 'obtenersesion':
                    print_r(json_encode($_userController->obtenerSesion($reqBody)));
                    break;
                    
                case 'obtenerpersona':
                    print_r(json_encode($_userController->obtenerPersona($reqBody)));
                    break;
                    
                case 'listarperfilespersona':
                    print_r(json_encode($_userController->listarPerfilPersona($reqBody)));
                    break;
                    
                case 'departamentopersona':
                    print_r(json_encode($_deptoController->obtenerDepartamentoSucursal($reqBody)));
                    break;
                    
                case 'obtenerpersonadepartamento':
                    print_r(json_encode($_userController->obtenerPersonaDepartamento($reqBody)));
                    break;
                    
                case 'obtenerpersonadepartamentosucursal':
                    print_r(json_encode($_userController->obtenerPersonaDepartamentoSucursal($reqBody)));
                    break;
                    
                case 'obtenerpersonadepartamentosucursalinactiva':
                    print_r(json_encode($_userController->obtenerPersonaDepartamentoSucursalInactiva($reqBody)));
                    break;
                    
                case 'obtenerpersonadepartamentodirector':
                    print_r(json_encode($_userController->obtenerPersonaDepartamentoDirector($reqBody)));
                    break;
                    
                case 'buscarpersonadepartamentodirector':
                    print_r(json_encode($_userController->buscarPersonaDepartamentoDirector($reqBody)));
                    break;
                    
                case 'buscarpersona':
                    print_r(json_encode($_userController->buscarPersona($reqBody)));
                    break;
                    
                case 'obtenerpersonasindepartamento':
                    print_r(json_encode($_userController->obtenerPersonaSinDepartamento()));
                    break;
                    
                case 'ingresarusuario':
                    print_r(json_encode($_userController->ingresarUsuario($reqBody)));
                    break;
                    
                case 'actualizarusuario':
                    print_r(json_encode($_userController->actualizarUsuario($reqBody)));
                    break;
                    
                case 'ingresarturnopersona':
                    print_r(json_encode($_userController->ingresarTurnoPersona($reqBody)));
                    break;
                    
                case 'ingresarperfilpersona':
                    print_r(json_encode($_userController->ingresarPerfilPersona($reqBody)));
                    break;
                    
                case 'eliminarperfilpersona':
                    print_r(json_encode($_userController->eliminarPerfilPersona($reqBody)));
                    break;
                    
                case 'eliminarcargopersona':
                    print_r(json_encode($_userController->eliminarCargoPersona($reqBody)));
                    break;
                    
                case 'ingresarcargopersona':
                    print_r(json_encode($_userController->ingresarCargoPersona($reqBody)));
                    break;
                    
                case 'eliminarturnopersona':
                    print_r(json_encode($_userController->eliminarTurnoPersona($reqBody)));
                    break;
                    
                case 'eliminardepartamentopersona':
                    print_r(json_encode($_userController->eliminarDeptoPersona($reqBody)));
                    break;
                    
                case 'ingresardepartamentopersona':
                    print_r(json_encode($_userController->ingresarDeptoPersona($reqBody)));
                    break;
                    
                case 'actualizarpantallausuario':
                    print_r(json_encode($_userController->actualizarPantallaUsuario($reqBody)));
                    break;
                    
                case 'actualizarfechacontratacion':
                    print_r(json_encode($_userController->actualizarFechaContratacion($reqBody)));
                    break;
                    
                case 'activarpersona':
                    print_r(json_encode($_userController->activarPersona($reqBody)));
                    break;
                    
                case 'buscarpersonainactiva':
                    print_r(json_encode($_userController->buscarPersonaInactiva($reqBody)));
                    break;
                    
                case 'obtenerpersonarut':
                    print_r(json_encode($_userController->obtenerPersona($reqBody)));
                    break;
                    
                //CARGOS
                case 'obtenercargoasignado':
                    print_r(json_encode($_userController->obtenerCargo($reqBody)));
                    break;
        
                case 'mostrarpersonacargo':
                    print_r(json_encode($_cargoController->mostrarCargoPersona($reqBody)));
                    break;
                    
                case 'cargo':
                    print_r(json_encode($_cargoController->listadoCargo()));
                    break;
                    
                //DEPARTAMENTOS
                case 'departamento':
                    print_r(json_encode($_deptoController->listadoDepartamento()));
                    break;
                    
                case 'obtenerdepartamentoasignado':
                    print_r(json_encode($_deptoController->obtenerDepartamento($reqBody)));
                    break;

                case 'obtenerdepartamentoprimarioasignado':
                    print_r(json_encode($_deptoController->obtenerDepartamentoPrimario($reqBody)));
                    break;

                case 'obtenerdepartamentosucursal':
                    print_r(json_encode($_deptoController->obtenerDeptoSucursal($reqBody)));
                    break;
                    
                //PERMISOS
                case 'permisoestadodepto':
                    print_r(json_encode($_permisoController->permisoEstadoDepto($reqBody)));
                    break;
                    
                case 'permisoestadodeptotipo':
                    print_r(json_encode($_permisoController->permisoEstadoDeptoTipo($reqBody)));
                    break;
                    
                case 'buscarpermiso':
                    print_r(json_encode($_permisoController->buscarPermiso($reqBody)));
                    break;
                        
                case 'obtenerpermiso':
                    print_r(json_encode($_permisoController->obtenerPermiso($reqBody)));
                    break;

                case 'obtenertipopermiso':
                    print_r(json_encode($_permisoController->obtenerTipoPermiso($reqBody)));
                    break;

                case 'listadotipopermiso':
                    print_r(json_encode($_permisoController->listadoTipoPermiso($reqBody)));
                    break;

                case 'permisoestado':
                    print_r(json_encode($_permisoController->permisoEstado($reqBody)));
                    break;
                        
                case 'ingresarpermiso':
                    print_r(json_encode($_permisoController->ingresarPermiso($reqBody)));
                    break;
                        
                case 'ingresarlogpermiso':
                    print_r(json_encode($_permisoController->ingresarLogPermiso($reqBody)));
                    break;
                        
                case 'actualizarpermiso':
                    print_r(json_encode($_permisoController->actualizarPermiso($reqBody)));
                    break;

                case 'modificarestadopermiso':
                    print_r(json_encode($_permisoController->modificarEstadoPermiso($reqBody)));
                    break;

                case 'buscarcargopermiso':
                    print_r(json_encode($_permisoController->buscarCargoPermiso($reqBody)));
                    break;
        
                case 'listarpermisostrabajadorgeneral':
                    print_r(json_encode($_permisoController->permisosTrabajadorGeneral($reqBody)));
                    break;
        
                case 'listarpermisostrabajadorgeneraltipopermiso':
                    print_r(json_encode($_permisoController->permisosTrabajadorTipoPermiso($reqBody)));
                    break;
        
                case 'permisoestadodeptosucursal':
                    print_r(json_encode($_permisoController->permisoEstadoDeptoSucursal($reqBody)));
                    break;
        
                case 'anularpermiso':
                    print_r(json_encode($_permisoController->anularPermiso($reqBody)));
                    break;
        
                case 'permisodigital':
                    print_r(json_encode($_permisoController->permisoDigital($reqBody)));
                    break;
                        
                case 'revisarpermiso':
                    print_r(json_encode($_permisoController->revisarPermiso($reqBody)));
                    break;
        
                case 'configuracionpermisopersona':
                    print_r(json_encode($_permisoController->configPermisoPersona($reqBody)));
                    break;
                    
                //SUCURSALES
                case 'sucursal':
                    print_r(json_encode($_sucursalController->obtenerSucursales()));
                    break;
        
                case 'listarfirmantesucursal':
                    print_r(json_encode($_firmanteController->obtenerFirmantesSucursal($reqBody)));
                    break;
        
                //HORAS EXTRA
                case 'informehoraextradepartamento':
                    print_r(json_encode($_horaExtraController->informeHorasExtraDepto($reqBody)));
                    break;
        
                case 'obtenerhoraextra':
                    print_r(json_encode($_horaExtraController->obtenerHoraExtra($reqBody)));
                    break;
        
                case 'ingresarhoraextra':
                    print_r(json_encode($_horaExtraController->ingresarHoraExtra($reqBody)));
                    break;
        
                case 'actualizarhoraextra':
                    print_r(json_encode($_horaExtraController->actualizarHoraExtra($reqBody)));
                    break;
        
                case 'eliminarhoraextra':
                    print_r(json_encode($_horaExtraController->eliminarHoraExtra($reqBody)));
                    break;
        
                case 'horaextradigital':
                    print_r(json_encode($_horaExtraController->horaExtraDigital($reqBody)));
                    break;
                
                //TURNOS
                case 'turnopersona':
                    print_r(json_encode($_turnoController->turnoPersona($reqBody)));
                    break;
        
                case 'obtenerlistadohorarioturno':
                    print_r(json_encode($_turnoController->listadoHorarioTurno($reqBody)));
                    break;
                    
                case 'turno':
                    print_r(json_encode($_turnoController->listadoTurno()));
                    break;
                    
        
                //MARCAJES
                case 'ultimasincronizacion':
                    print_r(json_encode($_marcajeController->ultimaSincronizacion()));
                    break;
        
                case 'informemarcadepartamentomanual':
                    print_r(json_encode($_marcajeController->informeMarcajeManualDepto($reqBody)));
                    break;
        
                case 'obtenermarcajemanual':
                    print_r(json_encode($_marcajeController->obtenerMarcajeManual($reqBody)));
                    break;
        
                case 'ingresarmarcajemanual':
                    print_r(json_encode($_marcajeController->ingresarMarcajeManual($reqBody)));
                    break;
        
                case 'marcajesreloj':
                    print_r(json_encode($_marcajeController->marcajesReloj($reqBody)));
                    break;
        
                case 'tipomarcaje':
                    print_r(json_encode($_marcajeController->tipoMarcaje()));
                    break;
        
                case 'marcajessincronizadostrabajador':
                    print_r(json_encode($_marcajeController->marcajesSincTrabajador($reqBody)));
                    break;
                    
                //MENSAJES
                case 'mensaje':
                    print_r(json_encode($_mensajeController->listadoMensaje()));
                    break;
                    
                case 'ingresarmensaje':
                    print_r(json_encode($_mensajeController->ingresarMensaje($reqBody)));
                    break;
                    
                case 'actualizarmensaje':
                    print_r(json_encode($_mensajeController->actualizarMensaje($reqBody)));
                    break;
                    
                case 'obtenermensaje':
                    print_r(json_encode($_mensajeController->obtenerMensaje($reqBody)));
                    break;
                    
                case 'eliminarmensaje':
                    print_r(json_encode($_mensajeController->eliminarMensaje($reqBody)));
                    break;
                    
                //PERFILES
                case 'perfiles':
                    print_r(json_encode($_perfilController->listadoPerfil()));
                    break;
                    
                //NACIONALIDADES
                case 'nacionalidad':
                    print_r(json_encode($_nacionalidadController->listadoNacionalidad()));
                    break;
                    
                //RELOJES
                case 'reloj':
                    print_r(json_encode($_relojController->listadoRelojes()));
                    break;
                    
                case 'obtenerreloj':
                    print_r(json_encode($_relojController->obtenerReloj($reqBody)));
                    break;
                    
                //EMPRESAS
                case 'empresa':
                    print_r(json_encode($_empresaController->obtenerEmpresas()));
                    break;
                    
                case 'obtenerempresasucursal':
                    print_r(json_encode($_sucursalController->obtenerSucursalesEmpresa($reqBody)));
                    break;
                    
                //JUSTIFICACIONES
                case 'informejustificacion':
                    print_r(json_encode($_justificacionController->listadoJustificacion($reqBody)));
                    break;
                    
                case 'obtenerjustificacion':
                    print_r(json_encode($_justificacionController->obtenerJustificacion($reqBody)));
                    break;
                    
                case 'obtenertipojustificacion':
                    print_r(json_encode($_justificacionController->obtenerTipoJustificacion($reqBody)));
                    break;
                    
                case 'tipojustificacion':
                    print_r(json_encode($_justificacionController->listadoTipoJustificacion()));
                    break;
                    
                case 'ingresarjustificacion':
                    print_r(json_encode($_justificacionController->ingresarJustificacion($reqBody)));
                    break;
                    
                case 'actualizarjustificacion':
                    print_r(json_encode($_justificacionController->actualizarJustificacion($reqBody)));
                    break;
                    
                case 'eliminarjustificacion':
                    print_r(json_encode($_justificacionController->eliminarJustificacion($reqBody)));
                    break;
                
                default:
                    print_r(json_encode($_responseController->error_404()));
                    break;
            }
            
        } else print_r(json_encode($_responseController->error_404()));
    } else {
        print_r(json_encode($_responseController->error_405()));
    }
    
?>