<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token, apikey');
    header('Accept: multipart/form-data');
    include_once dirname(__FILE__) . '/../controller/auth.controller.php';
    include_once dirname(__FILE__) . '/../controller/response.controller.php';

    if ($_SERVER['REQUEST_METHOD'] == "OPTIONS") {
        header('Access-Control-Allow-Headers: X-Requested-With, apikey');
        header("HTTP/1.1 200 OK");
        die();
    }

    $_authController = new AuthController;
    $_responseController = new ResponseController;

    if ($_SERVER['REQUEST_METHOD'] == "POST") {
        $reqBody = file_get_contents("php://input");
        $resArray = $_authController->logIn($reqBody);

        if ($resArray["result"] == 0 && $resArray["content"] == 0) print_r(json_encode($_responseController->error_400()));
        elseif ($resArray["result"] == 0) print_r(json_encode($_responseController->error_500($resArray["content"])));
        elseif ($resArray["content"] == 1) print_r(json_encode($_responseController->error_200("Wrong credentials")));
        else print_r(json_encode($_responseController->successBody($resArray["content"])));
    } else print_r(json_encode($_responseController->error_405()));
?>