<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class User {
        public function getUsers() {
            $cc = Database::getInstance();
        
            $sql = " SELECT * FROM users"; 
            $result = $cc->connection->prepare($sql);  
            $result->execute(); 
            return ($result); 
        }

        public function getUserByName($username) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT id, username, password FROM users WHERE username = :username"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("username" => $username);
                $result->execute($params); 
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function logIn($username, $password) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT id, usuario, contrasena FROM personas WHERE usuario = :usuario AND contrasena = :contrasena"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("usuario" => $username, "contrasena" => $password);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerSesion($username) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT id, id_pantalla, rut, nombre, apellido FROM personas WHERE usuario = :usuario"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("usuario" => $username);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersona($id) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM personas WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerCargo($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_cargo as id, b.descripcion
                    FROM cargo_personas a
                    INNER JOIN cargos b ON a.id_cargo = b.id
                    WHERE a.id_persona = :id_persona"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoPerfilPersona($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_perfil as id, b.descripcion, c.activo
                    FROM persona_perfiles a
                    INNER JOIN perfiles b ON a.id_perfil = b.id
                    INNER JOIN personas c ON a.id_persona = c.id
                    WHERE a.id_persona = :id_persona"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaDepartamento($idDepartamento) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.descripcion as turno, g.descripcion as departamento, f.descripcion as cargo
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    LEFT JOIN departamentos g ON a.id_departamento = g.id
                    WHERE a.id_departamento = :id_departamento
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_departamento" => $idDepartamento);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaDepartamentoSucursal($idDepartamento, $idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.descripcion as turno, f.descripcion as cargo, g.descripcion as departamento
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    INNER JOIN departamentos g ON a.id_departamento = g.id
                    WHERE a.id_departamento = :id_departamento
                    AND g.id_sucursal = :id_sucursal
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_departamento" => $idDepartamento, "id_sucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaDepartamentoSucursalInactiva($idDepartamento, $idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.descripcion as turno, f.descripcion as cargo, g.descripcion as departamento
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    INNER JOIN departamentos g ON a.id_departamento = g.id
                    WHERE a.id_departamento = :id_departamento
                    AND g.id_sucursal = :id_sucursal
                    AND a.primario = 1
                    AND b.activo = 0"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_departamento" => $idDepartamento, "id_sucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaSucursal($idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.descripcion as turno, f.descripcion as cargo, g.descripcion as departamento
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    INNER JOIN departamentos g ON a.id_departamento = g.id
                    WHERE g.id_sucursal = :id_sucursal
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_sucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaSucursalInactiva($idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.descripcion as turno, f.descripcion as cargo, g.descripcion as departamento
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    INNER JOIN departamentos g ON a.id_departamento = g.id
                    WHERE g.id_sucursal = :id_sucursal
                    AND a.primario = 1
                    AND b.activo = 0"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_sucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarPersona($descripcion) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT p.id as id_persona, p.rut, p.nombre, p.apellido, p.email, t.descripcion as turno, c.descripcion as cargo, d.descripcion as departamento
                    FROM personas p
                    LEFT JOIN persona_turnos pt ON p.id = pt.id_persona
                    LEFT JOIN turnos t ON pt.id_turno = t.id
                    LEFT JOIN cargo_personas cp ON p.id = cp.id_persona
                    LEFT JOIN cargos c ON cp.id_cargo = c.id
                    LEFT JOIN departamento_personas dp ON p.id = dp.id_persona
                    LEFT JOIN departamentos d ON dp.id_departamento = d.id
                    WHERE dp.primario = 1
                    AND (p.rut LIKE :criterio
                    OR p.nombre LIKE :criterio
                    OR p.apellido LIKE :criterio
                    OR p.pasaporte LIKE :criterio)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("criterio" => "%" . $descripcion . "%");
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaDepartamentoDirector($idDepartamento) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_persona, b.rut, b.nombre, b.apellido, b.email, d.id as idturno, d.descripcion as turno, f.descripcion as cargo, g.descripcion as departamento
                    FROM departamento_personas a
                    INNER JOIN personas b ON a.id_persona = b.id
                    LEFT JOIN persona_turnos c ON a.id_persona = c.id_persona
                    LEFT JOIN turnos d ON c.id_turno = d.id
                    LEFT JOIN cargo_personas e ON a.id_persona = e.id_persona
                    LEFT JOIN cargos f ON e.id_cargo = f.id
                    INNER JOIN departamentos g ON a.id_departamento = g.id
                    WHERE a.id_departamento = :id_departamento
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_departamento" => $idDepartamento);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarPersonaDepartamentoDirector($descripcion) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT p.id as id_persona, p.rut, p.nombre, p.apellido, p.email, t.id as idturno, t.descripcion as turno, c.descripcion as cargo, d.descripcion as departamento
                    FROM personas p
                    LEFT JOIN persona_turnos pt ON p.id = pt.id_persona
                    LEFT JOIN turnos t ON pt.id_turno = t.id
                    LEFT JOIN cargo_personas cp ON p.id = cp.id_persona
                    LEFT JOIN cargos c ON cp.id_cargo = c.id
                    LEFT JOIN departamento_personas dp ON p.id = dp.id_persona
                    LEFT JOIN departamentos d ON dp.id_departamento = d.id
                    WHERE dp.primario = 1
                    AND (p.rut LIKE :criterio
                    OR p.nombre LIKE :criterio
                    OR p.apellido LIKE :criterio
                    OR p.pasaporte LIKE :criterio)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("criterio" => "%" . $descripcion . "%");
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaSinDepartamento() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT p.*, t.descripcion as turno, c.descripcion as cargo 
                    FROM `personas` p 
                    LEFT JOIN persona_turnos pt ON p.id = pt.id_persona
                    LEFT JOIN turnos t ON pt.id_turno = t.id
                    LEFT JOIN cargo_personas cp ON p.id = cp.id_persona
                    LEFT JOIN cargos c ON cp.id_cargo = c.id
                    WHERE (SELECT count(*) FROM departamento_personas WHERE id_persona = p.id) = 0
                    AND p.activo = 1"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute();
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function validarExistenciaRut($rut) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT count(*) FROM personas WHERE rut = :rut "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("rut" => $rut);
                $result->execute($params);
                
                return $result->fetchColumn();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function validarExistenciaPasaporte($pasaporte) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT count(*) FROM personas WHERE pasaporte = :pasaporte "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("pasaporte" => $pasaporte);
                $result->execute($params);
                
                return $result->fetchColumn();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarUsuario($rut, $pasaporte, $nombre, $apellido, $telefono, $email, $idNacionalidad, $marca, $usuario, $contrasena) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO personas (rut, pasaporte, nombre, apellido, telefono, email, id_nacionalidad, activo, marca, usuario, contrasena, created_at, updated_at)
                    VALUES (:rut, :pasaporte, :nombre, :apellido, :telefono, :email, :id_nacionalidad, :activo, :marca, :usuario, :contrasena, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "rut" => $rut,
                    "pasaporte" => $pasaporte,
                    "nombre" => $nombre,
                    "apellido" => $apellido,
                    "telefono" => $telefono,
                    "email" => $email,
                    "id_nacionalidad" => $idNacionalidad,
                    "activo" => 1,
                    "marca" => $marca,
                    "usuario" => $usuario,
                    "contrasena" => $contrasena,
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt
                );
                
                if ($result->execute($params)) return $cc->connection->lastInsertId();
                else return 0;
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarUsuario($id, $rut, $pasaporte, $nombre, $apellido, $telefono, $email, $idNacionalidad, $marca, $usuario, $contrasena) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE personas 
                    SET rut = :rut, pasaporte = :pasaporte, nombre = :nombre, apellido = :apellido, telefono = :telefono, email = :email, id_nacionalidad = :id_nacionalidad, 
                    marca = :marca, usuario = :usuario, contrasena = :contrasena, updated_at = :updated_at 
                    WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => $id,
                    "rut" => $rut,
                    "pasaporte" => $pasaporte,
                    "nombre" => $nombre,
                    "apellido" => $apellido,
                    "telefono" => $telefono,
                    "email" => $email,
                    "id_nacionalidad" => $idNacionalidad,
                    "marca" => $marca,
                    "usuario" => $usuario,
                    "contrasena" => $contrasena,
                    "updated_at" => $updatedAt
                );
                
                $result->execute($params);
                
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarTurnoPersona($idPersona, $idTurno) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO persona_turnos (id_persona, id_turno) VALUES (:id_persona, :id_turno)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona, "id_turno" => $idTurno);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarPerfilPersona($idPersona, $idPerfil) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO persona_perfiles (id_persona, id_perfil) VALUES (:id_persona, :id_perfil)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona, "id_perfil" => $idPerfil);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarPerfilPersona($idPersona, $idPerfil) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM persona_perfiles WHERE id_persona = :id_persona AND id_perfil = :id_perfil "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona, "id_perfil" => $idPerfil);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarCargoPersona($idCargoPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM cargo_personas WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idCargoPersona);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarCargoPersona($idPersona, $idCargo) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO cargo_personas (id_persona, id_cargo) VALUES (:id_persona, :id_cargo)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona, "id_cargo" => $idCargo);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarTurnoPersona($idTurnoPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM persona_turnos WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idTurnoPersona);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarDeptoPersona($idDeptoPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM departamento_personas WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idDeptoPersona);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarDeptoPersona($idPersona, $idDepto) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO departamento_personas (id_persona, id_departamento, primario) VALUES (:id_persona, :id_departamento, :primario)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona, "id_departamento" => $idDepto, "primario" => 0);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarPantallaUsuario($idPersona, $idPantalla) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE personas SET id_pantalla = :id_pantalla WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idPersona, "id_pantalla" => $idPantalla);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarFechaContratacion($idPersona, $fecha) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE personas SET fecha_contratacion = :fecha_contratacion WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idPersona, "fecha_contratacion" => $fecha);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function activarPersona($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE personas SET activo = 1 WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idPersona);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarPersonaInactiva($descripcion) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT p.id as id_persona, p.rut, p.nombre, p.apellido, p.email, t.descripcion as turno, c.descripcion as cargo, d.descripcion as departamento
                    FROM personas p
                    LEFT JOIN persona_turnos pt ON p.id = pt.id_persona
                    LEFT JOIN turnos t ON pt.id_turno = t.id
                    LEFT JOIN cargo_personas cp ON p.id = cp.id_persona
                    LEFT JOIN cargos c ON cp.id_cargo = c.id
                    LEFT JOIN departamento_personas dp ON p.id = dp.id_persona
                    LEFT JOIN departamentos d ON dp.id_departamento = d.id
                    WHERE dp.primario = 1
                    AND p.activo = 0
                    AND (p.rut LIKE :criterio
                    OR p.nombre LIKE :criterio
                    OR p.apellido LIKE :criterio
                    OR p.pasaporte LIKE :criterio)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("criterio" => "%" . $descripcion . "%");
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerPersonaRut($rut) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM personas WHERE rut = :rut"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("rut" => $rut);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>