<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Turno {

        public function turnoPersona($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT pt.id, pt.id_turno, t.descripcion as turno
                    FROM persona_turnos pt
                    INNER JOIN turnos t ON pt.id_turno = t.id
                    WHERE pt.id_persona = :id_persona"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoHorarioTurno($idTurno) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT ht.id_turno as id, d.descripcion as dia, ht.hora_inicio, ht.hora_termino, ht.descanso
                    FROM horario_turnos ht
                    INNER JOIN dias d ON ht.id_dia = d.id
                    WHERE ht.id_turno = :id_turno"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_turno" => $idTurno);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoTurno() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM turnos"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>