<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';
    include_once dirname(__FILE__) . '/../core/database/sophid_api.php';

    class Soporte {
        public function getMessages() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.rut, a.nombre, a.idcliente, b.nombre as cliente, a.idsolucion, c.nombre as solucion, a.asunto, a.contenido, a.fecha, a.hora, a.imagen, a.leido 
                    FROM mensajes_soporte a
                    LEFT JOIN clientes b ON a.idcliente = b.id
                    LEFT JOIN soluciones c ON a.idsolucion = c.id
                    ORDER BY a.fecha DESC, a.hora DESC
                "; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            }
        }
        
        public function newMessage($rut, $nombre, $idCliente, $idSolucion, $asunto, $contenido, $fecha, $hora, $imagen) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO mensajes_soporte (rut, nombre, idcliente, idsolucion, asunto, contenido, fecha, hora, imagen, leido)
                    VALUES  (:rut, :nombre, :idcliente, :idsolucion, :asunto, :contenido, :fecha, :hora, :imagen, 0)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "rut" => $rut,
                    "nombre" => $nombre,
                    "idcliente" => $idCliente,
                    "idsolucion" => $idSolucion,
                    "asunto" => $asunto,
                    "contenido" => $contenido,
                    "fecha" => $fecha,
                    "hora" => $hora,
                    "imagen" => $imagen
                );
                $result->execute($params); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function getMessageById($id) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.rut, a.nombre, a.idcliente as id_cliente, b.nombre as nombre_cliente, a.idsolucion as id_solucion, c.nombre as nombre_solucion, a.asunto, a.contenido, a.fecha, a.hora, a.imagen, a.leido 
                    FROM mensajes_soporte a
                    LEFT JOIN clientes b ON a.idcliente = b.id
                    LEFT JOIN soluciones c ON a.idsolucion = c.id
                    WHERE a.id = :id
                "; 
                $result = $cc->connection->prepare($sql); 
                $params = array("id" => $id); 
                $result->execute($params); 
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            }
        }

        public function readMessage($id) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE mensajes_soporte
                    SET leido = 1
                    WHERE id = :id
                "; 
                $result = $cc->connection->prepare($sql); 
                $params = array("id" => $id); 
                if ($result->execute($params) && $result->rowCount() > 0) return true;
                else return false;
            } catch (PDOException $th) {
                return $th;
            }
        }

        public function getLastId() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT max(id) as id FROM mensajes_soporte"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>