<?php
    class Response {
        private $response = [
            "status" => "OK",
            "result" => array()
        ];

        public function success_200($msg) {
            $this->response['status'] = "OK";
            $this->response['result'] = array(
                "code" => 200,
                "message" => $msg
            );

            return $this->response;
        }

        public function error_400() {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 400,
                "message" => "Bad Request"
            );

            return $this->response;
        }

        public function error_400_msg($msg) {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 400,
                "message" => $msg
            );

            return $this->response;
        }

        public function error_401() {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 401,
                "message" => "Unauthorized"
            );

            return $this->response;
        }

        public function error_404() {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 404,
                "message" => "Not Found"
            );

            return $this->response;
        }

        public function error_405() {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 405,
                "message" => "Method Not Allowed"
            );

            return $this->response;
        }

        public function error_500($msg) {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 500,
                "message" => $msg
            );

            return $this->response;
        }

        public function error_200($msg = "Wrong Data") {
            $this->response['status'] = "ERROR";
            $this->response['result'] = array(
                "code" => 200,
                "message" => $msg
            );

            return $this->response;
        }
    }
?>