<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Reloj {

        public function obtenerReloj($idReloj) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM relojes WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idReloj);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarPermiso($fechaInicio, $fechaTermino, $fechaRetorno, $cantidad, $horaInicio, $horaTermino, $idTipoPermiso, $idPersona, $idAutoriza, $observacion, $jornada) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO permisos (fecha_inicio, fecha_termino, fecha_retorno, cantidad, hora_inicio, hora_termino, id_tipo_permiso, id_persona, id_autoriza, id_estado, id_reposo, observacion, motivo, pdfacepta, idacepta, revisado, jornada, created_at, updated_at)
                    VALUES (:fecha_inicio, :fecha_termino, :fecha_retorno, :cantidad, :hora_inicio, :hora_termino, :id_tipo_permiso, :id_persona, :id_autoriza, :id_estado, :id_reposo, :observacion, :motivo, :pdfacepta, :idacepta, :revisado, :jornada, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha_inicio" => $fechaInicio,
                    "fecha_termino" => $fechaTermino,
                    "fecha_retorno" => $fechaRetorno,
                    "cantidad" => $cantidad,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_tipo_permiso" => $idTipoPermiso,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "id_estado" => 1,
                    "id_reposo" => 0,
                    "observacion" => $observacion,
                    "motivo" => null,
                    "pdfacepta" => null,
                    "idacepta" => 0,
                    "revisado" => 0,
                    "jornada" => $jornada,
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt,
                );
                
                if ($result->execute($params)) return $cc->connection->lastInsertId();
                else return 0;
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarPermiso($id, $fechaInicio, $fechaTermino, $fechaRetorno, $cantidad, $horaInicio, $horaTermino, $idTipoPermiso, $idPersona, $idAutoriza, $observacion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE permisos SET fecha_inicio=:fecha_inicio, fecha_termino=:fecha_termino, fecha_retorno=:fecha_retorno, cantidad=:cantidad, hora_inicio=:hora_inicio, hora_termino=:hora_termino, id_tipo_permiso=:id_tipo_permiso, id_persona=:id_persona, id_autoriza=:id_autoriza, observacion=:observacion, updated_at=:updated_at
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => $id,
                    "fecha_inicio" => $fechaInicio,
                    "fecha_termino" => $fechaTermino,
                    "fecha_retorno" => $fechaRetorno,
                    "cantidad" => $cantidad,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_tipo_permiso" => $idTipoPermiso,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "observacion" => $observacion,
                    "updated_at" => $updatedAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoRelojes() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT r.id, r.descripcion, r.modelo, s.descripcion as sucursal
                    FROM relojes r
                    INNER JOIN sucursales s ON r.id_sucursal = s.id "; 
                $result = $cc->connection->prepare($sql);  
                    
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoDepto($fechaInicio, $fechaTermino, $idDepto) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, g.descripcion as tipopermiso, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.id_departamento = :iddepto
                    AND b.fecha_inicio >= :fechainicio AND b.fecha_inicio <= :fechatermino
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "iddepto" => $idDepto,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoEstado($fechaInicio, $fechaTermino, $idEstado) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha_inicio, a.fecha_termino, a.fecha_retorno, a.cantidad, a.pdfacepta, b.descripcion as tipopermiso, b.formato, c.rut, c.nombre, c.apellido, d.descripcion as estado 
                    FROM permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN personas c ON a.id_persona = c.id 
                    INNER JOIN estados d ON a.id_estado = d.id 
                    WHERE a.id_estado = :idestado
                    AND a.fecha_inicio >= :fechainicio AND a.fecha_inicio <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idestado" => $idEstado,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoEstadoDeptoSucursal($fechaInicio, $fechaTermino, $idDepto, $idSucursal, $idEstado) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, g.descripcion as tipopermiso, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.id_departamento = :iddepto 
                    AND b.id_estado = :idestado
                    AND e.id_sucursal = :idsucursal
                    AND b.fecha_inicio >= :fechainicio AND b.fecha_inicio <= :fechatermino
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "iddepto" => $idDepto,
                    "idestado" => $idEstado,
                    "idsucursal" => $idSucursal,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerTipoPermiso($idTipoPermiso) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_permisos WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idTipoPermiso);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarLogPermiso($idPermiso, $idUsuario, $observacion, $fecha, $hora) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO log_permisos (fecha, hora, id_permiso, id_usuario, observacion)
                    VALUES (:fecha, :hora, :id_permiso, :id_usuario, :observacion)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha" => $fecha,
                    "hora" => $hora,
                    "id_permiso" => $idPermiso,
                    "id_usuario" => $idUsuario,
                    "observacion" => $observacion
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisosTrabajadorGeneral($fechaInicio, $fechaTermino, $idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha_inicio, a.fecha_termino, a.fecha_retorno, a.cantidad, a.observacion, b.descripcion as tipopermiso, c.rut, c.nombre, c.apellido, e.descripcion as estado, a.jornada, b.formato 
                    FROM permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN personas c ON a.id_persona = c.id 
                    INNER JOIN estados e ON a.id_estado = e.id 
                    WHERE a.id_persona = :idpersona
                    AND a.fecha_inicio >= :fechainicio AND a.fecha_inicio <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idpersona" => $idPersona,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisosTrabajadorTipoPermiso($fechaInicio, $fechaTermino, $idPersona, $idTipoPermiso) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha_inicio, a.fecha_termino, a.fecha_retorno, a.cantidad, a.observacion, b.descripcion as tipopermiso, c.rut, c.nombre, c.apellido 
                    FROM permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN personas c ON a.id_persona = c.id 
                    WHERE a.id_persona = :idpersona AND a.id_tipo_permiso = :idtipopermiso
                    AND a.fecha_inicio >= :fechainicio AND a.fecha_inicio <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idpersona" => $idPersona,
                    "idtipopermiso" => $idTipoPermiso,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function configPermisoPersona($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.cantidad, b.descripcion as tipopermiso, count(c.id) as cantidadsistema
                    FROM configuracion_permiso_personas a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN permisos c ON a.id_persona = c.id_persona 
                    WHERE a.id_persona = :idpersona"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("idpersona" => $idPersona);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarCargoPermiso($idCargo) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_tipo_permiso, b.descripcion as tipopermiso
                    FROM cargo_permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    WHERE a.id_cargo = :idcargo"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idcargo" => $idCargo,
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function anularPermiso($id, $idEstado, $motivo) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE permisos
                    SET id_estado = :idestado
                    WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idestado" => $idEstado,
                    "id" => $id
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoDigital($id, $pdfAcepta) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE permisos SET pdfacepta = :pdfacepta WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "pdfacepta" => $pdfAcepta,
                    "id" => $id
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function modificarEstadoPermiso($id, $idEstado) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE permisos SET id_estado = :id_estado, updated_at = :updated
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id, "id_estado" => $idEstado, "updated" => $updatedAt);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function revisarPermiso($id) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE permisos SET revisado = 1, updated_at = :updated
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id, "updated" => $updatedAt);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function listadoTipoPermiso() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_permisos"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoEstadoDeptoTipo($fechaInicio, $fechaTermino, $idDepto, $idTipo, $idEstado) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, b.revisado, b.id_tipo_permiso, g.descripcion as tipopermiso, b.id_estado, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.id_departamento = :iddepto 
                    AND b.fecha_inicio >= :fechainicio AND b.fecha_termino <= :fechatermino
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "iddepto" => (int)$idDepto,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                /* if ($idEstado != 0 && $idEstado != "0") {
                    $sql .= " AND b.id_estado = :idestado";
                    $params2 = array(
                        "idestado" => (int)$idEstado
                    );
                    $params = array_merge($params, $params2);
                }
                if ($idTipo != 0 && $idTipo != "0") {
                    $sql .= " AND b.id_tipo_permiso = :idtipopermiso";
                    $params2 = array(
                        "idtipopermiso" => (int)$idTipo
                    );
                    $params = array_merge($params, $params2);
                } */
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                error_log(json_encode($th));
                return $th;
            } 
        }

        public function buscarPermiso($criterio) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, b.revisado, g.descripcion as tipopermiso, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.primario = 1
                    AND b.id = :id
                    OR c.nombre LIKE :criterio
                    OR c.apellido LIKE :criterio"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => (int)$criterio,
                    "criterio" => "%" . $criterio . "%"
                );
                $result->execute($criterio); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>