<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Mensaje {

        public function listadoMensaje() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM mensajes"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerMensaje($idMensaje) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM mensajes WHERE id = :id "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idMensaje);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }


        public function ingresarMensaje($descripcion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO mensajes (descripcion, created_at, updated_at)
                    VALUES (:descripcion, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "descripcion" => $descripcion,
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarMensaje($idMensaje, $descripcion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE mensajes SET descripcion = :descripcion, updated_at = :updated_at WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => $idMensaje,
                    "descripcion" => $descripcion,
                    "updated_at" => $updatedAt
                );
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarMensaje($idMensaje) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM mensajes WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idMensaje);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>