<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Marcaje {
        public function ultimaSincronizacion() {
            $cc = Database::getInstance();
        
            $sql = " CALL pa_ultima_sincronizacion ()"; 
            $result = $cc->connection->prepare($sql);  
            $result->execute(); 
            return $result->fetch(PDO::FETCH_OBJ); 
        }

        public function informeMarcajeManualDepto($fechaInicio, $fechaTermino, $idDepto) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT mm.*, tm.descripcion as tipomarca, e.descripcion as estado
                    FROM marcajemanuales mm
                    INNER JOIN tipo_marcajes tm ON mm.id_tipo_marca = tm.id
                    INNER JOIN estados e ON mm.id_estado = e.id
                    WHERE mm.id_departamento = :id_departamento 
                    AND mm.fecha >= :fechainicio AND mm.fecha <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id_departamento" => (int)$idDepto,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerMarcajeManual($idMarcaje) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT id, fecha, hora, rut, nombre, apellido, id_autoriza, id_tipo_marcaje
                    FROM marcajemanuales
                    WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idMarcaje);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarMarcajeManual($fecha, $observacion, $hora, $rut, $nombre, $apellido, $idDepartamento, $departamento, $idSucursal, $sucursal, $idTipoMarcaje, $idMensaje, $idAutoriza) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO marcajemanuales (fecha, hora, rut, nombre, apellido, id_departamento, departamento, id_sucursal, sucursal, id_tipo_marcaje, observacion, id_tipo_marca, id_estado, id_mensaje, id_autoriza, idturno, created_at, updated_at)
                    VALUES (:fecha, :hora, :rut, :nombre, :apellido, :id_departamento, :departamento, :id_sucursal, :sucursal, :id_tipo_marcaje, :observacion, :id_tipo_marca, :id_estado, :id_mensaje, :id_autoriza, :idturno, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha" => $fecha,
                    "hora" => $hora,
                    "rut" => $rut,
                    "nombre" => $nombre,
                    "apellido" => $apellido,
                    "id_departamento" => $idDepartamento,
                    "departamento" => $departamento,
                    "id_sucursal" => $idSucursal,
                    "sucursal" => $sucursal,
                    "id_tipo_marcaje" => $idTipoMarcaje,
                    "observacion" => $observacion,
                    "id_tipo_marca" => 2,
                    "id_estado" => 1,
                    "id_mensaje" => $idMensaje,
                    "id_autoriza" => $idAutoriza,
                    "idturno" => 0,
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function fechaHoraUltMarcaje($idReloj) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT fecha, hora FROM marcajes WHERE id = (SELECT max(id) FROM marcajes WHERE id_reloj = :id_reloj) "; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_reloj" => $idReloj);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function marcajesReloj($idReloj, $fechaInicio, $fechaTermino) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM marcajes WHERE id_reloj = :id_reloj AND fecha >= :fechainicio AND fecha <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id_reloj" => (int)$idReloj,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function tipoMarcaje() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_marcajes "; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function marcajesSincTrabajador($rut, $fechaInicio, $fechaTermino) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM marcajes WHERE rut = :rut AND fecha >= :fechainicio AND fecha <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "rut" => $rut,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>