<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Justificacion {

        public function obtenerJustificacion($idJustificacion) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM justificaciones WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idJustificacion);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerTipoJustificacion($idTipoJustificacion) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_justificaciones WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idTipoJustificacion);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarJustificacion($fecha, $horaInicio, $horaTermino, $idTipoJustificacion, $idTipoMarcaje, $idPersona, $idAutoriza, $observacion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO justificaciones (fecha, hora_inicio, hora_termino, id_tipo_justificacion, id_tipo_marcaje, id_persona, id_autoriza, observacion, created_at, updated_at)
                    VALUES (:fecha, :hora_inicio, :hora_termino, :id_tipo_justificacion, :id_tipo_marcaje, :id_persona, :id_autoriza, :observacion, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha" => $fecha,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_tipo_justificacion" => $idTipoJustificacion,
                    "id_tipo_marcaje" => $idTipoMarcaje,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "observacion" => $observacion,
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarJustificacion($id, $fecha, $horaInicio, $horaTermino, $idTipoJustificacion, $idTipoMarcaje, $idPersona, $idAutoriza, $observacion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE justificaciones SET fecha=:fecha, hora_inicio=:hora_inicio, hora_termino=:hora_termino, id_tipo_justificacion=:id_tipo_justificacion, id_tipo_marcaje=:id_tipo_marcaje, id_persona=:id_persona, id_autoriza=:id_autoriza, observacion=:observacion, updated_at=:updated_at
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => $id,
                    "fecha" => $fecha,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_tipo_justificacion" => $idTipoJustificacion,
                    "id_tipo_marcaje" => $idTipoMarcaje,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "observacion" => $observacion,
                    "updated_at" => $updatedAt,
                );
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarJustificacion($id) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM justificaciones WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id);
                
                $result->execute($params);
                return $result->rowCount();
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoJustificacion($fechaInicio, $fechaTermino) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha, b.hora_inicio, b.hora_termino, b.id_tipo_justificacion, d.descripcion as tipojustificacion, c.rut, c.nombre, c.apellido 
                    FROM justificaciones b 
                    INNER JOIN personas c ON b.id_persona = c.id
                    INNER JOIN tipo_justificaciones d ON b.id_tipo_justificacion = d.id
                    WHERE b.fecha >= :fechainicio AND b.fecha <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                
                $params = array(
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                    
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function listadoTipoJustificacion() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_justificaciones"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarPermiso($criterio) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, b.revisado, g.descripcion as tipopermiso, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.primario = 1
                    AND b.id = :id
                    OR c.nombre LIKE :criterio
                    OR c.apellido LIKE :criterio"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => (int)$criterio,
                    "criterio" => "%" . $criterio . "%"
                );
                $result->execute($criterio); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>