<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class HoraExtra {

        public function obtenerHoraExtra($idPermiso) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha, a.hora_inicio, a.hora_termino, a.cantidad, a.observacion, c.id as idpersona, c.rut as rut_persona, c.nombre as nombre_persona, c.apellido as apellido_persona, c.email, d.id as idautoriza, d.rut as rut_autoriza, d.nombre as nombre_autoriza, d.apellido as apellido_autoriza, e.id as idestado, e.descripcion as estado, f.id_cargo as id_cargo_autoriza, g.descripcion as cargo_autoriza, h.id_cargo as id_cargo_persona, i.descripcion as cargo_persona, a.created_at
                    FROM hora_extras a
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN personas d ON a.id_autoriza = d.id
                    INNER JOIN estados e ON a.id_estado = e.id
                    LEFT JOIN cargo_personas f ON a.id_autoriza = f.id_persona
                    LEFT JOIN cargos g ON f.id_cargo = g.id
                    LEFT JOIN cargo_personas h ON a.id_persona = h.id_persona
                    LEFT JOIN cargos i ON h.id_cargo = i.id
                    WHERE a.id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idPermiso);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarHoraExtra($fecha, $cantidad, $horaInicio, $horaTermino, $idPersona, $idAutoriza, $observacion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $createdAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " INSERT INTO hora_extras (fecha, cantidad, hora_inicio, hora_termino, id_persona, id_autoriza, id_estado, observacion, pdfacepta, created_at, updated_at)
                    VALUES (:fecha, :cantidad, :hora_inicio, :hora_termino, :id_persona, :id_autoriza, :id_estado, :observacion, :pdfacepta, :created_at, :updated_at)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha" => $fecha,
                    "cantidad" => $cantidad,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "id_estado" => 1,
                    "observacion" => $observacion,
                    "pdfacepta" => "",
                    "created_at" => $createdAt,
                    "updated_at" => $createdAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function actualizarHoraExtra($id, $fecha, $cantidad, $horaInicio, $horaTermino, $idPersona, $idAutoriza, $observacion) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE hora_extras SET fecha=:fecha, cantidad=:cantidad, hora_inicio=:hora_inicio, hora_termino=:hora_termino, id_persona=:id_persona, id_autoriza=:id_autoriza, observacion=:observacion, updated_at=:updated_at
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "id" => $id,
                    "fecha" => $fecha,
                    "cantidad" => $cantidad,
                    "hora_inicio" => $horaInicio,
                    "hora_termino" => $horaTermino,
                    "id_persona" => $idPersona,
                    "id_autoriza" => $idAutoriza,
                    "observacion" => $observacion,
                    "updated_at" => $updatedAt,
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function eliminarHoraExtra($id) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM hora_extras WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function informeHorasExtraDepto($fechaInicio, $fechaTermino, $idDepto) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha, b.cantidad, b.hora_inicio, b.hora_termino, b.observacion, b.pdfacepta, d.descripcion as estado, c.rut, c.nombre, c.apellido, g.descripcion as cargo, t.descripcion as turno
                    FROM departamento_personas a 
                    INNER JOIN hora_extras b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    LEFT JOIN cargo_personas f ON a.id_persona = f.id_cargo
                    LEFT JOIN cargos g ON f.id_cargo = g.id
                    INNER JOIN persona_turnos h ON a.id_persona = h.id_persona
                    LEFT JOIN turnos t ON h.id_turno = t.id
                    WHERE a.id_departamento = :iddepto 
                    AND b.fecha BETWEEN :fechainicio AND :fechatermino
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "iddepto" => (int)$idDepto,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoEstado($fechaInicio, $fechaTermino, $idEstado) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha_inicio, a.fecha_termino, a.fecha_retorno, a.cantidad, a.pdfacepta, b.descripcion as tipopermiso, b.formato, c.rut, c.nombre, c.apellido, d.descripcion as estado 
                    FROM permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN personas c ON a.id_persona = c.id 
                    INNER JOIN estados d ON a.id_estado = d.id 
                    WHERE a.id_estado = :idestado
                    AND a.fecha_inicio >= :fechainicio AND a.fecha_inicio <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idestado" => $idEstado,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisoEstadoDeptoSucursal($fechaInicio, $fechaTermino, $idDepto, $idSucursal, $idEstado) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT b.id, b.fecha_inicio, b.fecha_termino, b.fecha_retorno, b.cantidad, b.pdfacepta, g.descripcion as tipopermiso, d.descripcion as estado, c.rut, c.nombre, c.apellido, f.descripcion as sucursal, e.descripcion as departamento, g.formato 
                    FROM departamento_personas a 
                    INNER JOIN permisos b ON a.id_persona = b.id_persona 
                    INNER JOIN personas c ON a.id_persona = c.id
                    INNER JOIN estados d ON b.id_estado = d.id
                    INNER JOIN departamentos e ON a.id_departamento = e.id
                    INNER JOIN sucursales f ON e.id_sucursal = f.id
                    INNER JOIN tipo_permisos g ON b.id_tipo_permiso = g.id 
                    WHERE a.id_departamento = :iddepto 
                    AND b.id_estado = :idestado
                    AND e.id_sucursal = :idsucursal
                    AND b.fecha_inicio >= :fechainicio AND b.fecha_inicio <= :fechatermino
                    AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "iddepto" => $idDepto,
                    "idestado" => $idEstado,
                    "idsucursal" => $idSucursal,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerTipoPermiso($idTipoPermiso) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM tipo_permisos WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $idTipoPermiso);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function ingresarLogPermiso($idPermiso, $idUsuario, $observacion, $fecha, $hora) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO log_permisos (fecha, hora, id_permiso, id_usuario, observacion)
                    VALUES (:fecha, :hora, :id_permiso, :id_usuario, :observacion)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "fecha" => $fecha,
                    "hora" => $hora,
                    "id_permiso" => $idPermiso,
                    "id_usuario" => $idUsuario,
                    "observacion" => $observacion
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function permisosTrabajadorTipoPermiso($fechaInicio, $fechaTermino, $idPersona, $idTipoPermiso) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.fecha_inicio, a.fecha_termino, a.fecha_retorno, a.cantidad, a.observacion, b.descripcion as tipopermiso, c.rut, c.nombre, c.apellido 
                    FROM permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN personas c ON a.id_persona = c.id 
                    WHERE a.id_persona = :idpersona AND a.id_tipo_permiso = :idtipopermiso
                    AND a.fecha_inicio >= :fechainicio AND a.fecha_inicio <= :fechatermino"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idpersona" => $idPersona,
                    "idtipopermiso" => $idTipoPermiso,
                    "fechainicio" => $fechaInicio,
                    "fechatermino" => $fechaTermino
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function configPermisoPersona($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.cantidad, b.descripcion as tipopermiso, count(c.id) as cantidadsistema
                    FROM configuracion_permiso_personas a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    INNER JOIN permisos c ON a.id_persona = c.id_persona 
                    WHERE a.id_persona = :idpersona"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("idpersona" => $idPersona);
                $result->execute($params); 
                
                return $result->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function buscarCargoPermiso($idCargo) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_tipo_permiso, b.descripcion as tipopermiso
                    FROM cargo_permisos a 
                    INNER JOIN tipo_permisos b ON a.id_tipo_permiso = b.id 
                    WHERE a.id_cargo = :idcargo"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idcargo" => $idCargo,
                );
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function horaExtraDigital($id, $pdfAcepta) {
            $cc = Database::getInstance();
        
            try {
                $sql = " UPDATE hora_extras SET pdfacepta = :pdfacepta WHERE id = :id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "pdfacepta" => $pdfAcepta,
                    "id" => $id
                );
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function modificarEstadoPermiso($id, $idEstado) {
            $cc = Database::getInstance();
            date_default_timezone_set("America/Santiago");
            $updatedAt = date('Y-m-d H:i:s');
        
            try {
                $sql = " UPDATE permisos SET id_estado = :id_estado, updated_at = :updated
                    WHERE id=:id"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id" => $id, "id_estado" => $idEstado, "updated" => $updatedAt);
                
                return $result->execute($params);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>