<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Firmante {

        public function obtenerFirmantesSucursal($idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT rut, email, nombre FROM firmantes WHERE idsucursal = :idsucursal"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("idsucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerFirmantesSucursalDepartamento($idSucursal, $idDepto) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT rut, email, nombre FROM firmantes WHERE idsucursal = :idsucursal AND iddepartamento = :iddepto"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("idsucursal" => $idSucursal, "iddepto" => $idDepto);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>