<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';

    class Departamento {

        public function obtenerDepartamento($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_departamento as id, b.descripcion
                    FROM departamento_personas a
                    INNER JOIN departamentos b ON a.id_departamento = b.id
                    WHERE a.id_persona = :id_persona
                    ORDER BY b.descripcion ASC"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerDepartamentoPrimario($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id_departamento as id, b.descripcion as departamento, c.descripcion as sucursal, c.id as idsucursal
                    FROM departamento_personas a
                    INNER JOIN departamentos b ON a.id_departamento = b.id
                    INNER JOIN sucursales c ON c.id = b.id_sucursal
                    WHERE a.id_persona = :id_persona AND a.primario = 1"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerDepartamentoSucursal($idPersona) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT a.id, a.id_departamento as id_departamento, b.descripcion as departamento, c.descripcion as sucursal, a.primario
                    FROM departamento_personas a
                    INNER JOIN departamentos b ON a.id_departamento = b.id
                    INNER JOIN sucursales c ON b.id_sucursal = c.id
                    WHERE a.id_persona = :id_persona
                    ORDER BY b.descripcion ASC"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_persona" => $idPersona);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function obtenerDeptoSucursal($idSucursal) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT id, descripcion
                    FROM departamentos
                    WHERE id_sucursal = :id_sucursal
                    ORDER BY descripcion ASC"; 
                $result = $cc->connection->prepare($sql);  
                $params = array("id_sucursal" => $idSucursal);
                $result->execute($params); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function listadoDepartamento() {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT * FROM departamentos"; 
                $result = $cc->connection->prepare($sql);  
                $result->execute(); 
                
                return ($result);
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>