<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';
    include_once dirname(__FILE__) . '/../core/database/sophid_api.php';

    class Cronjob {
        public function newReaderLog($readerId, $time) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO cron_lectores (idlector, hora, estado)
                    VALUES  (:idlector, :hora, 0)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idlector" => $readerId,
                    "hora" => $time
                );
                $result->execute($params); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function getReaderLogs($readerId) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT count(*) FROM cron_lectores
                    WHERE idlector = :idlector"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idlector" => $readerId
                );
                $result->execute($params); 
                return $result->fetchColumn(); 
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function deleteReaderLogs($readerId) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM cron_lectores
                    WHERE idlector = :idlector"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idlector" => $readerId
                );
                $result->execute($params); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            } 
        }

        public function newServerLog($serverId, $time) {
            $cc = Database::getInstance();
        
            try {
                $sql = " INSERT INTO cron_servidores (idservidor, hora, estado)
                    VALUES  (:idservidor, :hora, 0)"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idservidor" => $serverId,
                    "hora" => $time
                );
                $result->execute($params); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function getServerLogs($serverId) {
            $cc = Database::getInstance();
        
            try {
                $sql = " SELECT count(*) FROM cron_servidores
                    WHERE idservidor = :idservidor"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idservidor" => $serverId
                );
                $result->execute($params); 
                return $result->fetchColumn(); 
            } catch (PDOException $th) {
                return $th;
            } 
        }
        
        public function deleteServerLogs($serverId) {
            $cc = Database::getInstance();
        
            try {
                $sql = " DELETE FROM cron_servidores
                    WHERE idservidor = :idservidor"; 
                $result = $cc->connection->prepare($sql);  
                $params = array(
                    "idservidor" => $serverId
                );
                $result->execute($params); 
                return ($result); 
            } catch (PDOException $th) {
                return $th;
            } 
        }
    }
?>