<?php
    include_once dirname(__FILE__) . '/../core/database/database.php';
    include_once dirname(__FILE__) . '/../core/responses.php';
    include_once dirname(__FILE__) . '/../core/users.php';
    require dirname(__FILE__) . '/../vendor/autoload.php';

    use ReallySimpleJWT\Token;
    use ReallySimpleJWT\Exception;

    class Auth extends Database {
        public function logIn($username, $password) {
            $_user = new User;
            $resLogin = $_user->getUserByName($username);

            if (is_a($resLogin, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($resLogin)
            );
            elseif (!$resLogin)  return array(
                "result" => 0,
                "content" => 0
            );
            else {
                if (!password_verify($password, $resLogin->password)) return array(
                    "result" => 0,
                    "content" => 0
                );
                else {
                    //GENERO TOKEN
                    $expiration = time() + (3600 * 24 * 365);
                    $secret = 'sec!ReT423*&';
                    $token = Token::create($resLogin->id, $secret, $expiration, 'localhost');
                    $resArray = array(
                        "user_id" => $resLogin->id,
                        "username" => $resLogin->username,
                        "token" => $token
                    );
                    return array(
                        "result" => 1,
                        "content" => $resArray
                    );
                }
            }
        }

        public function logInCliente($rut, $password) {
            $_user = new User;
            $resLogin = $_user->getClientUserByRut($rut);

            if (is_a($resLogin, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($resLogin)
            );
            elseif (!$resLogin)  return array(
                "result" => 0,
                "content" => 0
            );
            else {
                //$clientResponse = $_clientRequest->getFromClient("POST", $resLogin->urlplataforma . "appservicios/controller/usercontroller.php", json_encode($postData));
                if (!password_verify($password, $resLogin->password)) return array(
                    "result" => 0,
                    "content" => 0
                );
                else {
                    //GENERO TOKEN
                    $expiration = time() + (3600 * 24 * 31);
                    $secret = 'Cl13+t*5cUR1t&#tkÑ';
                    $token = Token::create($resLogin->rut, $secret, $expiration, 'localhost');
                    $resArray = array(
                        "rut" => $resLogin->rut,
                        "nombre" => $resLogin->nombre,
                        "apellidos" => $resLogin->apellidos,
                        "id_cliente" => $resLogin->idcliente,
                        "nombre_cliente" => $resLogin->nombrecliente,
                        "id_solucion" => $resLogin->idsolucion,
                        "urlplataforma" => $resLogin->urlplataforma,
                        "token" => $token
                    );
                    return array(
                        "result" => 1,
                        "content" => $resArray
                    );
                }
            }
        }

        public function validateToken($token) {
            $secret = 'sec!ReT423*&';

            try {
                $res = Token::validate($token, $secret);

                if (!$res) {
                    return array("result" => 0, "content" => "Invalid token");
                } else {
                    $payload = Token::getPayload($token);
                    return array(
                        "result" => 1,
                        "user_id" => $payload["user_id"]
                    );
                }
            } catch (Exception\ParsedException $th) {
                return array("result" => 0, "content" => "Invalid token");
            }
        }
    }
?>