<?php
    include_once dirname(__FILE__) . '/../core/users.php';

    class UserController {
        public function logIn($jsonData) {
            $_user = new User;

            $data = json_decode($jsonData, true);
            if (!isset($data['usuario']) || !isset($data['contrasena'])) return array(0);
            else {
                $res = $_user->logIn($data['usuario'], $data['contrasena']);
                if (is_a($res, "PDOException")) return array(0);
                elseif (!$res) return array(0);
                else return array(1);
            }
        }

        public function obtenerSesion($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['usuario'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerSesion($data['usuario']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function obtenerPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerPersona($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    //$tabla[0] = [];
                    array_push($tabla, array(
                        "id" => $res->id,
                        "rut" => $res->rut,
                        "pasaporte" => $res->pasaporte,
                        "fecha_contratacion" => $res->fecha_contratacion,
                        "nombre" => htmlspecialchars($res->nombre),
                        "apellido" => htmlspecialchars($res->apellido),
                        "email" => $res->email,
                        "telefono" => $res->telefono,
                        "usuario" => $res->usuario,
                        "contrasena" => $res->contrasena,
                        "marca" => $res->marca,
                        "id_pantalla" => $res->id_pantalla,
                        "id_nacionalidad" => $res->id_nacionalidad
                    ));
                }
            }
            return $tabla;
        }

        public function obtenerCargo($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerCargo($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function listarPerfilPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['idpersona'])) array_push($tabla, 0);
            else {
                $res = $_user->listadoPerfilPersona($data['idpersona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        $tabla[0][] = array(
                            "id" => $row['id'],
                            "descripcion" => htmlspecialchars($row['descripcion']),
                            "activo" => $row['activo']
                        );
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaDepartamento($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_departamento'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerPersonaDepartamento($data['id_departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "turno" => htmlspecialchars($row['turno']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "cargo" => htmlspecialchars($row['cargo']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaDepartamentoSucursal($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_departamento']) || !isset($data['id_sucursal'])) array_push($tabla, 0);
            else {
                if ($data['id_departamento'] != 0) $res = $_user->obtenerPersonaDepartamentoSucursal($data['id_departamento'], $data['id_sucursal']);
                else $res = $_user->obtenerPersonaSucursal($data['id_sucursal']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaDepartamentoSucursalInactiva($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_departamento']) || !isset($data['id_sucursal'])) array_push($tabla, 0);
            else {
                if ($data['id_departamento'] != 0) $res = $_user->obtenerPersonaDepartamentoSucursalInactiva($data['id_departamento'], $data['id_sucursal']);
                else $res = $_user->obtenerPersonaSucursalInactiva($data['id_sucursal']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function buscarPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['descripcion'])) array_push($tabla, 0);
            else {
                $res = $_user->buscarPersona($data['descripcion']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaDepartamentoDirector($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_departamento'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerPersonaDepartamentoDirector($data['id_departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "idturno" => $row['idturno'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function buscarPersonaDepartamentoDirector($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['ruttrabajador'])) array_push($tabla, 0);
            else {
                $res = $_user->buscarPersonaDepartamentoDirector($data['ruttrabajador']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "idturno" => $row['idturno'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaSinDepartamento() {
            $_user = new User;
            $tabla = [];

            $res = $_user->obtenerPersonaSinDepartamento();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (!$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "rut" => $row['rut'],
                        "nombre" => htmlspecialchars($row['nombre']),
                        "apellido" => htmlspecialchars($row['apellido']),
                        "email" => $row['email'],
                        "turno" => htmlspecialchars($row['turno']),
                        "cargo" => htmlspecialchars($row['cargo']),
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarUsuario($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['rut']) || 
                !isset($data['pasaporte']) || 
                !isset($data['nombre']) || 
                !isset($data['apellido']) || 
                !isset($data['telefono']) || 
                !isset($data['email']) || 
                !isset($data['id_nacionalidad']) || 
                !isset($data['marca']) || 
                !isset($data['usuario']) || 
                !isset($data['contrasena'])
            ) array_push($tabla, 0);
            else {
                if ($_user->validarExistenciaRut($data['rut']) == 0 && $_user->validarExistenciaPasaporte($data['pasaporte']) == 0) {
                    $res = $_user->ingresarUsuario(
                        $data['rut'],
                        $data['pasaporte'],
                        $data['nombre'],
                        $data['apellido'],
                        $data['telefono'], 
                        $data['email'],
                        $data['id_nacionalidad'],
                        $data['marca'],
                        $data['usuario'],
                        $data['contrasena']
                    );
                } else {
                    $res = 2;
                }
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function actualizarUsuario($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || 
                !isset($data['rut']) || 
                !isset($data['pasaporte']) || 
                !isset($data['nombre']) || 
                !isset($data['apellido']) || 
                !isset($data['telefono']) || 
                !isset($data['email']) || 
                !isset($data['id_nacionalidad']) || 
                !isset($data['marca']) || 
                !isset($data['usuario']) || 
                !isset($data['contrasena'])
            ) array_push($tabla, 0);
            else {
                $res = $_user->actualizarUsuario(
                    $data['id'],
                    $data['rut'],
                    $data['pasaporte'],
                    $data['nombre'],
                    $data['apellido'],
                    $data['telefono'], 
                    $data['email'],
                    $data['id_nacionalidad'],
                    $data['marca'],
                    $data['usuario'],
                    $data['contrasena']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function ingresarTurnoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona']) || !isset($data['id_turno'])) array_push($tabla, 0);
            else {
                $res = $_user->ingresarTurnoPersona($data['id_persona'], $data['id_turno']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function ingresarPerfilPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona']) || !isset($data['id_perfil'])) array_push($tabla, 0);
            else {
                $res = $_user->ingresarPerfilPersona($data['id_persona'], $data['id_perfil']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function eliminarPerfilPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona']) || !isset($data['id_perfil'])) array_push($tabla, 0);
            else {
                $res = $_user->eliminarPerfilPersona($data['id_persona'], $data['id_perfil']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function eliminarCargoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_user->eliminarCargoPersona($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function ingresarCargoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona']) || !isset($data['id_cargo'])) array_push($tabla, 0);
            else {
                $res = $_user->ingresarCargoPersona($data['id_persona'], $data['id_cargo']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function eliminarTurnoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_user->eliminarTurnoPersona($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function eliminarDeptoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_user->eliminarDeptoPersona($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function ingresarDeptoPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona']) || !isset($data['id_departamento'])) array_push($tabla, 0);
            else {
                $res = $_user->ingresarDeptoPersona($data['id_persona'], $data['id_departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function actualizarPantallaUsuario($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['id_pantalla'])) array_push($tabla, 0);
            else {
                $res = $_user->actualizarPantallaUsuario($data['id'], $data['id_pantalla']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function actualizarFechaContratacion($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['fecha_contratacion'])) array_push($tabla, 0);
            else {
                $res = $_user->actualizarFechaContratacion($data['id'], $data['fecha_contratacion']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function activarPersona($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_user->activarPersona($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function buscarPersonaInactiva($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['descripcion'])) array_push($tabla, 0);
            else {
                $res = $_user->buscarPersonaInactiva($data['descripcion']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id_persona'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "email" => $row['email'],
                            "turno" => htmlspecialchars($row['turno']),
                            "cargo" => htmlspecialchars($row['cargo']),
                            "departamento" => htmlspecialchars($row['departamento']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerPersonaRut($jsonData) {
            $_user = new User;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['rut'])) array_push($tabla, 0);
            else {
                $res = $_user->obtenerPersonaRut($data['rut']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res) array_push($tabla, 0);
                else {
                    //$tabla[0] = [];
                    array_push($tabla, array(
                        "id" => $res->id,
                        "rut" => $res->rut,
                        "nombre" => htmlspecialchars($res->nombre),
                        "apellido" => htmlspecialchars($res->apellido)
                    ));
                }
            }
            return $tabla;
        }
    }
?>