<?php
    include_once dirname(__FILE__) . '/../core/turnos.php';

    class TurnoController {

        public function turnoPersona($jsonData) {
            $_turno = new Turno;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_turno->turnoPersona($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "id_turno" => $row['id_turno'],
                            "descripcion" => htmlspecialchars($row['turno'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function listadoHorarioTurno($jsonData) {
            $_turno = new Turno;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_turno'])) array_push($tabla, 0);
            else {
                $res = $_turno->listadoHorarioTurno($data['id_turno']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id_turno" => $row['id'],
                            "dia" => htmlspecialchars($row['dia']),
                            "hora_inicio" => $row['hora_inicio'],
                            "hora_termino" => $row['hora_termino'],
                            "descanso" => $row['descanso']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function listadoTurno() {
            $_turno = new Turno;
            $tabla = [];

            $res = $_turno->listadoTurno();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }
    }
?>