<?php
    include_once dirname(__FILE__) . '/../core/sucursales.php';

    class SucursalController {

        public function obtenerSucursales() {
            $_sucursal = new Sucursal;
            $tabla = [];

            $res = $_sucursal->obtenerSucursales();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }

        public function obtenerSucursalesEmpresa($jsonData) {
            $_sucursal = new Sucursal;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_empresa'])) array_push($tabla, 0);
            else {
                $res = $_sucursal->obtenerSucursalesEmpresa($data['id_empresa']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "descripcion" => htmlspecialchars($row['descripcion'])
                        ));
                    }
                }
            }
            return $tabla;
        }
    }
?>