<?php
    include_once dirname(__FILE__) .'/../core/soporte.php';
    include_once dirname(__FILE__) .'/../controller/cliente.controller.php';
    include_once dirname(__FILE__) .'/../core/notificaciones.php';

    class SoporteController {
        public function getMensajes() {
            $_soporte = new Soporte;
            $resArray = array();

            $mensajes = $_soporte->getMessages();
            if (is_a($mensajes, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($mensajes)
            );
            else {
                foreach ($mensajes as $row) {
                    array_push($resArray, array(
                        "id" => $row['id'],
                        "rut" => $row['rut'],
                        "nombre" => $row['nombre'],
                        "id_cliente" => $row['idcliente'],
                        "nombre_cliente" => $row['cliente'],
                        "id_solucion" => $row['idsolucion'],
                        "nombre_solucion" => $row['solucion'],
                        "asunto" => $row['asunto'],
                        "contenido" => $row['contenido'],
                        "fecha" => $row['fecha'],
                        "hora" => $row['hora'],
                        "imagen" => $row['imagen'],
                        "leido" => $row['leido']
                    ));
                }

                return array(
                    "result" => 1,
                    "content" => $resArray
                );
            }
        }

        public function nuevoMensaje($infoMensaje) {
            $_soporte = new Soporte;

            $data = json_decode($infoMensaje, true);

            if (!isset($data['rut']) || !isset($data['nombre']) || !isset($data['idcliente']) || !isset($data['idsolucion']) || !isset($data['asunto']) || !isset($data['contenido']) || !isset($data['imagen'])) return array(
                "result" => 0,
                "content" => false
            );
            else {
                date_default_timezone_set("America/Santiago");
                $dateNow = date_format(date_create("now"), "Y-m-d H:i:s");
                $fecha = @reset(explode(" ", $dateNow));
                $hora = @end(explode(" ", $dateNow));
                $res = $_soporte->newMessage($data['rut'], $data['nombre'], $data['idcliente'], $data['idsolucion'], $data['asunto'], $data['contenido'], $fecha, $hora, $data['imagen']);
                if (is_a($res, "PDOException")) return array(
                    "result" => 0,
                    "content" => json_encode($res)
                ); 
                else {
                    if ($res) {
                        $_clienteController = new ClienteController;
                        $getCliente = $_clienteController->getClienteId($data['idcliente']);

                        if ($getCliente["result"] == 0) $nombreCliente = "--no encontrado--";
                        else $nombreCliente = $getCliente["content"]->nombre;

                        $_notificacion = new Notificacion;
                        $enviarNotif = $_notificacion->enviarNotificacion($data['nombre'], $nombreCliente, $hora);

                        return array(
                            "result" => 1,
                            "content" => "Message sent."
                        );
                    } else return array(
                        "result" => 0,
                        "content" => "Error sending message."
                    );
                }
            }
        }

        public function getMensajeId($id) {
            $_soporte = new Soporte;

            $mensaje = $_soporte->getMessageById($id);
            if (is_a($mensaje, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($mensaje)
            ); 
            else return array(
                "result" => 1,
                "content" => $mensaje
            );
        }

        public function leerMensaje($id) {
            $_soporte = new Soporte;

            $res = $_soporte->readMessage($id);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else {
                if ($res) return array(
                    "result" => 1,
                    "content" => "Mensaje leido."
                );
                else return array(
                    "result" => 0,
                    "content" => false
                );
            }
        }

        public function obtenerUltimoId() {
            $_soporte = new Soporte;

            $res = $_soporte->getLastId();
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else {
                if ($res->id) return array(
                    "result" => 1,
                    "content" => $res->id
                );
                else return array(
                    "result" => 0,
                    "content" => false
                );
            }
        }
    }
?>