<?php
    include_once dirname(__FILE__) . '/../core/responses.php';

    class ResponseController {
        public function successNoBody($msg) {
            $_response = new Response;

            header('HTTP/1.1 200 OK');
            return $_response->success_200($msg);
        }

        public function successBody($result) {
            header('HTTP/1.1 200 OK');
            return $result;
        }

        public function error_400() {
            $_response = new Response;

            header('HTTP/1.1 400 Bad Request');
            return $_response->error_400();
        }

        public function error_400_msg($msg) {
            $_response = new Response;

            header('HTTP/1.1 400 Bad Request');
            return $_response->error_400_msg($msg);
        }

        public function error_401() {
            $_response = new Response;

            header('HTTP/1.1 401 Unauthorized');
            return $_response->error_401();
        }

        public function error_404() {
            $_response = new Response;

            header('HTTP/1.1 404 Not Found');
            return $_response->error_404();
        }

        public function error_405() {
            $_response = new Response;

            header('HTTP/1.1 405 Method Not Allowed');
            return $_response->error_405();
        }

        public function error_500($msg) {
            $_response = new Response;

            header('HTTP/1.1 500 Internal Server Error');
            return $_response->error_500($msg);
        }

        public function error_200($msg) {
            $_response = new Response;

            return $_response->error_200($msg);
        }
    }
?>