<?php
    include_once dirname(__FILE__) . '/../core/permisos.php';

    class PermisoController {

        public function obtenerPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_permiso->obtenerPermiso($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "fecha_inicio" => $res->fecha_inicio,
                        "fecha_termino" => $res->fecha_termino,
                        "fecha_retorno" => $res->fecha_retorno,
                        "cantidad" => $res->cantidad,
                        "hora_inicio" => $res->hora_inicio,
                        "hora_termino" => $res->hora_termino,
                        "jornada" => $res->jornada,
                        "observacion" => htmlspecialchars($res->observacion),
                        "id_tipo_permiso" => $res->id_tipopermiso,
                        "tipopermiso" => htmlspecialchars($res->tipopermiso),
                        "ley" => htmlspecialchars($res->ley),
                        "observacion_ley" => htmlspecialchars($res->observacion_ley),
                        "tipopermiso_hora" => $res->tipopermiso_hora,
                        "id_persona" => $res->idpersona,
                        "rut_persona" => $res->rut_persona,
                        "nombre_persona" => htmlspecialchars($res->nombre_persona),
                        "apellido_persona" => htmlspecialchars($res->apellido_persona),
                        "email" => $res->email,
                        "id_autoriza" => $res->idautoriza,
                        "rut_autoriza" => $res->rut_autoriza,
                        "nombre_autoriza" => htmlspecialchars($res->nombre_autoriza),
                        "apellido_autoriza" => htmlspecialchars($res->apellido_autoriza),
                        "id_estado" => $res->idestado,
                        "estado" => htmlspecialchars($res->estado),
                        "id_cargo_autoriza" => $res->id_cargo_autoriza,
                        "cargo_autoriza" => htmlspecialchars($res->cargo_autoriza),
                        "id_cargo_persona" => $res->id_cargo_persona,
                        "cargo_persona" => htmlspecialchars($res->cargo_persona),
                        "created_at" => $res->created_at
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || 
                !isset($data['fecha_termino']) || 
                !isset($data['fecha_retorno']) || 
                !isset($data['cantidad']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_tipo_permiso']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion']) || 
                !isset($data['jornada'])
            ) array_push($tabla, 0);
            else {
                $res = $_permiso->ingresarPermiso(
                    $data['fecha_inicio'],
                    $data['fecha_termino'],
                    $data['fecha_retorno'],
                    $data['cantidad'],
                    $data['hora_inicio'], 
                    $data['hora_termino'],
                    $data['id_tipo_permiso'],
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion'],
                    $data['jornada']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function actualizarPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || 
                !isset($data['fecha_inicio']) || 
                !isset($data['fecha_termino']) || 
                !isset($data['fecha_retorno']) || 
                !isset($data['cantidad']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_tipo_permiso']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion'])
            ) array_push($tabla, 0);
            else {
                $res = $_permiso->actualizarPermiso(
                    $data['id'],
                    $data['fecha_inicio'],
                    $data['fecha_termino'],
                    $data['fecha_retorno'],
                    $data['cantidad'],
                    $data['hora_inicio'], 
                    $data['hora_termino'],
                    $data['id_tipo_permiso'],
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function permisoEstadoDepto($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_departamento']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                if ($data['id_estado'] != 0) $res = $_permiso->permisoEstadoDepto($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento'], $data['id_estado']);
                else $res = $_permiso->permisoDepto($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "formato" => $row['formato'],
                            "revisado" => $row['revisado']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function permisoEstado($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoEstado($data['fecha_inicio'], $data['fecha_termino'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "formato" => $row['formato']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function permisoEstadoDeptoSucursal($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_departamento']) || !isset($data['id_sucursal']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoEstadoDeptoSucursal($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento'], $data['id_sucursal'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "formato" => $row['formato']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerTipoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_permiso->obtenerTipoPermiso($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    array_push($tabla[0], array(
                        "id" => $res->id,
                        "descripcion" => htmlspecialchars($res->descripcion),
                        "congoce" => $res->congoce,
                        "hora" => $res->hora,
                        "ley" => htmlspecialchars($res->ley),
                        "observacion" => htmlspecialchars($res->observacion),
                        "formato" => $res->formato,
                        "codigoerp" => $res->codigoerp,
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarLogPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_permiso']) || !isset($data['id_usuario']) || !isset($data['observacion'])) array_push($tabla, 0);
            else {
                date_default_timezone_set("America/Santiago");
                $fecha = date('Y-m-d');
                $hora = date('H:i:s');
                $res = $_permiso->ingresarLogPermiso($data['id_permiso'], $data['id_usuario'], $data['observacion'], $fecha, $hora);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function permisosTrabajadorTipoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_persona']) || !isset($data['id_tipo_permiso'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisosTrabajadorTipoPermiso($data['fecha_inicio'], $data['fecha_termino'], $data['id_persona'], $data['id_tipo_permiso']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "cantidad" => $row['cantidad'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "observacion" => htmlspecialchars($row['observacion'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function permisosTrabajadorGeneral($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisosTrabajadorGeneral($data['fecha_inicio'], $data['fecha_termino'], $data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "cantidad" => $row['cantidad'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "observacion" => htmlspecialchars($row['observacion']),
                            "estado" => $row['estado'],
                            "total" => $row['jornada'],
                            "formato" => $row['formato']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function configPermisoPersona($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_permiso->configPermisoPersona($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    array_push($tabla[0], array(
                        "tipo" => htmlspecialchars($res->tipopermiso),
                        "cantidad" => $res->cantidad,
                        "cantidadsistema" => $res->cantidadsistema,
                    ));
                }
            }
            return $tabla;
        }

        public function buscarCargoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_cargo'])) array_push($tabla, 0);
            else {
                $res = $_permiso->buscarCargoPermiso($data['id_cargo']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id_tipo_permiso" => $row['id_tipo_permiso'],
                            "tipopermiso" => htmlspecialchars($row['tipopermiso']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function anularPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['id_estado']) || !isset($data['motivo'])) array_push($tabla, 0);
            else {
                $res = $_permiso->anularPermiso($data['id'], $data['id_estado'], $data['motivo']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function permisoDigital($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['pdfacepta'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoDigital($data['id'], $data['pdfacepta']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function modificarEstadoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->modificarEstadoPermiso($data['id'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function revisarPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_permiso->revisarPermiso($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function listadoTipoPermiso() {
            $_permiso = new Permiso;
            $tabla = [];

            $res = $_permiso->listadoTipoPermiso();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion']),
                        "congoce" => $row['congoce'],
                        "hora" => $row['hora'],
                        "ley" => htmlspecialchars($row['ley']),
                        "observacion" => htmlspecialchars($row['observacion']),
                        "formato" => $row['formato'],
                        "codigoerp" => $row['codigoerp'],
                    ));
                }
            }
            return $tabla;
        }

        public function permisoEstadoDeptoTipo($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_departamento']) || !isset($data['id_tipo_permiso']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoEstadoDeptoTipo($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento'], $data['id_tipo_permiso'], $data['id_estado']);
                error_log(json_encode($res));
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    if ($data['id_tipo_permiso'] > 0 && $data['id_estado'] > 0) {
                        foreach ($res as $row) {
                            if ($row['id_tipo_permiso'] == $data['id_tipo_permiso'] && $row['id_estado'] == $data['id_estado']) {
                                array_push($tabla[0], array(
                                    "id" => $row['id'],
                                    "fecha_inicio" => $row['fecha_inicio'],
                                    "fecha_termino" => $row['fecha_termino'],
                                    "fecha_retorno" => $row['fecha_retorno'],
                                    "total" => $row['cantidad'],
                                    "pdfacepta" => $row['pdfacepta'],
                                    "tipo" => htmlspecialchars($row['tipopermiso']),
                                    "estado" => htmlspecialchars($row['estado']),
                                    "rut" => $row['rut'],
                                    "nombre" => htmlspecialchars($row['nombre']),
                                    "apellido" => htmlspecialchars($row['apellido']),
                                    "sucursal" => htmlspecialchars($row['sucursal']),
                                    "departamento" => htmlspecialchars($row['departamento']),
                                    "formato" => $row['formato'],
                                    "revisado" => $row['revisado']
                                ));
                            }
                        }
                    } elseif ($data['id_tipo_permiso'] > 0) {
                        foreach ($res as $row) {
                            if ($row['id_tipo_permiso'] == $data['id_tipo_permiso']) {
                                array_push($tabla[0], array(
                                    "id" => $row['id'],
                                    "fecha_inicio" => $row['fecha_inicio'],
                                    "fecha_termino" => $row['fecha_termino'],
                                    "fecha_retorno" => $row['fecha_retorno'],
                                    "total" => $row['cantidad'],
                                    "pdfacepta" => $row['pdfacepta'],
                                    "tipo" => htmlspecialchars($row['tipopermiso']),
                                    "estado" => htmlspecialchars($row['estado']),
                                    "rut" => $row['rut'],
                                    "nombre" => htmlspecialchars($row['nombre']),
                                    "apellido" => htmlspecialchars($row['apellido']),
                                    "sucursal" => htmlspecialchars($row['sucursal']),
                                    "departamento" => htmlspecialchars($row['departamento']),
                                    "formato" => $row['formato'],
                                    "revisado" => $row['revisado']
                                ));
                            }
                        }
                    } elseif ($data['id_estado'] > 0) {
                        foreach ($res as $row) {
                            if ($row['id_estado'] == $data['id_estado']) {
                                array_push($tabla[0], array(
                                    "id" => $row['id'],
                                    "fecha_inicio" => $row['fecha_inicio'],
                                    "fecha_termino" => $row['fecha_termino'],
                                    "fecha_retorno" => $row['fecha_retorno'],
                                    "total" => $row['cantidad'],
                                    "pdfacepta" => $row['pdfacepta'],
                                    "tipo" => htmlspecialchars($row['tipopermiso']),
                                    "estado" => htmlspecialchars($row['estado']),
                                    "rut" => $row['rut'],
                                    "nombre" => htmlspecialchars($row['nombre']),
                                    "apellido" => htmlspecialchars($row['apellido']),
                                    "sucursal" => htmlspecialchars($row['sucursal']),
                                    "departamento" => htmlspecialchars($row['departamento']),
                                    "formato" => $row['formato'],
                                    "revisado" => $row['revisado']
                                ));
                            }
                        }
                    } else {
                        foreach ($res as $row) {
                            array_push($tabla[0], array(
                                "id" => $row['id'],
                                "fecha_inicio" => $row['fecha_inicio'],
                                "fecha_termino" => $row['fecha_termino'],
                                "fecha_retorno" => $row['fecha_retorno'],
                                "total" => $row['cantidad'],
                                "pdfacepta" => $row['pdfacepta'],
                                "tipo" => htmlspecialchars($row['tipopermiso']),
                                "estado" => htmlspecialchars($row['estado']),
                                "rut" => $row['rut'],
                                "nombre" => htmlspecialchars($row['nombre']),
                                "apellido" => htmlspecialchars($row['apellido']),
                                "sucursal" => htmlspecialchars($row['sucursal']),
                                "departamento" => htmlspecialchars($row['departamento']),
                                "formato" => $row['formato'],
                                "revisado" => $row['revisado']
                            ));
                        }
                    }
                }
            }
            return $tabla;
        }

        public function buscarPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['criterio'])) array_push($tabla, 0);
            else {
                $res = $_permiso->buscarPermiso($data['criterio']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "formato" => $row['formato'],
                            "revisado" => $row['revisado']
                        ));
                    }
                }
            }
            return $tabla;
        }
    }
?>