<?php
    include_once dirname(__FILE__) . '/../core/mensajes.php';

    class MensajeController {

        public function listadoMensaje() {
            $_mensaje = new Mensaje;
            $tabla = [];

            $res = $_mensaje->listadoMensaje();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }

        public function obtenerMensaje($jsonData) {
            $_mensaje = new Mensaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_mensaje->obtenerMensaje($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "descripcion" => htmlspecialchars($res->descripcion)
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarMensaje($jsonData) {
            $_mensaje = new Mensaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['descripcion'])) array_push($tabla, 0);
            else {
                $res = $_mensaje->ingresarMensaje($data['descripcion']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function actualizarMensaje($jsonData) {
            $_mensaje = new Mensaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['descripcion'])) array_push($tabla, 0);
            else {
                $res = $_mensaje->actualizarMensaje($data['id'], $data['descripcion']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function eliminarMensaje($jsonData) {
            $_mensaje = new Mensaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_mensaje->eliminarMensaje($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }
    }
?>