<?php
    include_once dirname(__FILE__) . '/../core/marcajes.php';

    class MarcajeController {
        public function ultimaSincronizacion() {
            $_marcaje = new Marcaje;
            $tabla = [];

            $res = $_marcaje->ultimaSincronizacion();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (!$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                array_push($tabla[0], array(
                    "fechasincroniza" => $res->fechasincroniza,
                    "horasincroniza" => $res->horasincroniza,
                    "cantidad" => $res->cantidad,
                    "fecha" => $res->fecha,
                    "hora" => $res->hora
                ));
            }

            return $tabla;
        }

        public function informeMarcajeManualDepto($jsonData) {
            $_marcaje = new Marcaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_departamento'])) array_push($tabla, 0);
            else {
                $res = $_marcaje->informeMarcajeManualDepto($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha" => $row['fecha'],
                            "hora" => $row['hora'],
                            "tipomarca" => $row['tipomarca'],
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "estado" => htmlspecialchars($row['estado']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerMarcajeManual($jsonData) {
            $_marcaje = new Marcaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_marcaje->obtenerMarcajeManual($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "fecha" => $res->fecha,
                        "hora" => $res->hora,
                        "rut" => $res->rut,
                        "nombre" => htmlspecialchars($res->nombre),
                        "apellido" => htmlspecialchars($res->apellido),
                        "id_autoriza" => $res->id_autoriza,
                        "id_tipo_marcaje" => $res->id_tipo_marcaje
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarMarcajeManual($jsonData) {
            $_marcaje = new Marcaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha']) || 
                !isset($data['observacion']) || 
                !isset($data['hora']) || 
                !isset($data['rut']) || 
                !isset($data['nombre']) || 
                !isset($data['apellido']) || 
                !isset($data['id_departamento']) || 
                !isset($data['departamento']) || 
                !isset($data['id_sucursal']) || 
                !isset($data['sucursal']) || 
                !isset($data['id_tipo_marcaje']) || 
                !isset($data['id_mensaje']) || 
                !isset($data['id_autoriza'])
            ) array_push($tabla, 0);
            else {
                $res = $_marcaje->ingresarMarcajeManual(
                    $data['fecha'],
                    $data['observacion'],
                    $data['hora'],
                    $data['rut'],
                    $data['nombre'], 
                    $data['apellido'],
                    $data['id_departamento'],
                    $data['departamento'],
                    $data['id_sucursal'],
                    $data['sucursal'],
                    $data['id_tipo_marcaje'],
                    $data['id_mensaje'],
                    $data['id_autoriza']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function marcajesReloj($jsonData) {
            $_marcaje = new Marcaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_reloj']) || !isset($data['fecha_inicio']) || !isset($data['fecha_termino'])) array_push($tabla, 0);
            else {
                $res = $_marcaje->marcajesReloj($data['id_reloj'], $data['fecha_inicio'], $data['fecha_termino']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha" => $row['fecha'],
                            "hora" => $row['hora'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function tipoMarcaje() {
            $_marcaje = new Marcaje;
            $tabla = [];

            $res = $_marcaje->tipoMarcaje();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }

        public function marcajesSincTrabajador($jsonData) {
            $_marcaje = new Marcaje;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['rut']) || !isset($data['fecha_inicio']) || !isset($data['fecha_termino'])) array_push($tabla, 0);
            else {
                $res = $_marcaje->marcajesSincTrabajador($data['rut'], $data['fecha_inicio'], $data['fecha_termino']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha" => $row['fecha'],
                            "hora" => $row['hora'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                        ));
                    }
                }
            }
            return $tabla;
        }
    }
?>