<?php
    include_once dirname(__FILE__) . '/../core/justificaciones.php';

    class JustificacionController {

        public function obtenerJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_justificacion->obtenerJustificacion($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "fecha" => $res->fecha,
                        "hora_inicio" => $res->hora_inicio,
                        "hora_termino" => $res->hora_termino,
                        "id_tipo_justificacion" => $res->id_tipo_justificacion,
                        "id_tipo_marcaje" => $res->id_tipo_marcaje,
                        "id_persona" => $res->id_persona,
                        "id_autoriza" => $res->id_autoriza,
                        "observacion" => htmlspecialchars($res->observacion)
                    ));
                }
            }
            return $tabla;
        }

        public function obtenerTipoJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_justificacion->obtenerTipoJustificacion($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "descripcion" => htmlspecialchars($res->descripcion)
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_tipo_justificacion']) || 
                !isset($data['id_tipo_marcaje']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion'])
            ) array_push($tabla, 0);
            else {
                $res = $_justificacion->ingresarJustificacion(
                    $data['fecha'],
                    $data['hora_inicio'],
                    $data['hora_termino'],
                    $data['id_tipo_justificacion'],
                    $data['id_tipo_marcaje'], 
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function actualizarJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || 
                !isset($data['fecha']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_tipo_justificacion']) || 
                !isset($data['id_tipo_marcaje']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion'])
            ) array_push($tabla, 0);
            else {
                $res = $_justificacion->actualizarJustificacion(
                    $data['id'],
                    $data['fecha'],
                    $data['hora_inicio'],
                    $data['hora_termino'],
                    $data['id_tipo_justificacion'],
                    $data['id_tipo_marcaje'], 
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function eliminarJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_justificacion->eliminarJustificacion($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function listadoJustificacion($jsonData) {
            $_justificacion = new Justificacion;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino'])) array_push($tabla, 0);
            else {
                $res = $_justificacion->listadoJustificacion($data['fecha_inicio'], $data['fecha_termino']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha" => $row['fecha'],
                            "hora_inicio" => $row['hora_inicio'],
                            "hora_termino" => $row['hora_termino'],
                            "id_tipo_justificacion" => $row['id_tipo_justificacion'],
                            "tipo_justificacion" => htmlspecialchars($row['tipojustificacion']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function listadoTipoJustificacion() {
            $_justificacion = new Justificacion;
            $tabla = [];

            $res = $_justificacion->listadoTipoJustificacion();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }

        public function buscarPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['criterio'])) array_push($tabla, 0);
            else {
                $res = $_permiso->buscarPermiso($data['criterio']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                            "departamento" => htmlspecialchars($row['departamento']),
                            "formato" => $row['formato'],
                            "revisado" => $row['revisado']
                        ));
                    }
                }
            }
            return $tabla;
        }
    }
?>