<?php
    include_once dirname(__FILE__) . '/../core/horasextra.php';

    class HoraExtraController {

        public function obtenerHoraExtra($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_hora->obtenerHoraExtra($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    array_push($tabla, array(
                        "id" => $res->id,
                        "fecha" => $res->fecha,
                        "hora_inicio" => $res->hora_inicio,
                        "hora_termino" => $res->hora_termino,
                        "cantidad" => $res->cantidad,
                        "observacion" => htmlspecialchars($res->observacion),
                        "id_persona" => $res->idpersona,
                        "rut_persona" => $res->rut_persona,
                        "nombre_persona" => htmlspecialchars($res->nombre_persona),
                        "apellido_persona" => htmlspecialchars($res->apellido_persona),
                        "email" => $res->email,
                        "id_autoriza" => $res->idautoriza,
                        "rut_autoriza" => $res->rut_autoriza,
                        "nombre_autoriza" => htmlspecialchars($res->nombre_autoriza),
                        "apellido_autoriza" => htmlspecialchars($res->apellido_autoriza),
                        "id_estado" => $res->idestado,
                        "estado" => htmlspecialchars($res->estado),
                        "id_cargo_autoriza" => $res->id_cargo_autoriza,
                        "cargo_autoriza" => htmlspecialchars($res->cargo_autoriza),
                        "id_cargo_persona" => $res->id_cargo_persona,
                        "cargo_persona" => htmlspecialchars($res->cargo_persona),
                        "created_at" => $res->created_at
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarHoraExtra($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha']) || 
                !isset($data['cantidad']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion'])
            ) array_push($tabla, 0);
            else {
                $res = $_hora->ingresarHoraExtra(
                    $data['fecha'],
                    $data['cantidad'],
                    $data['hora_inicio'], 
                    $data['hora_termino'],
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, $res);
            }
            return $tabla;
        }

        public function actualizarHoraExtra($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || 
                !isset($data['fecha']) || 
                !isset($data['cantidad']) || 
                !isset($data['hora_inicio']) || 
                !isset($data['hora_termino']) || 
                !isset($data['id_persona']) || 
                !isset($data['id_autoriza']) || 
                !isset($data['observacion'])
            ) array_push($tabla, 0);
            else {
                $res = $_hora->actualizarHoraExtra(
                    $data['id'],
                    $data['fecha'],
                    $data['cantidad'],
                    $data['hora_inicio'], 
                    $data['hora_termino'],
                    $data['id_persona'],
                    $data['id_autoriza'],
                    $data['observacion']
                );
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function eliminarHoraExtra($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_hora->eliminarHoraExtra($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function informeHorasExtraDepto($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['departamento'])) array_push($tabla, 0);
            else {
                $res = $_hora->informeHorasExtraDepto($data['fecha_inicio'], $data['fecha_termino'], $data['departamento']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        $cargo = "";
                        if ($row['cargo'] != null) $cargo = $row['cargo'];
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha" => $row['fecha'],
                            "hora_inicio" => $row['hora_inicio'],
                            "hora_termino" => $row['hora_termino'],
                            "cantidad" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "cargo" => htmlspecialchars($cargo),
                            "turno" => htmlspecialchars($row['turno']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function permisoEstado($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoEstado($data['fecha_inicio'], $data['fecha_termino'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "formato" => $row['formato']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function permisoEstadoDeptoSucursal($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_departamento']) || !isset($data['id_sucursal']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisoEstadoDeptoSucursal($data['fecha_inicio'], $data['fecha_termino'], $data['id_departamento'], $data['id_sucursal'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "total" => $row['cantidad'],
                            "pdfacepta" => $row['pdfacepta'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "estado" => htmlspecialchars($row['estado']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "formato" => $row['formato']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerTipoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id'])) array_push($tabla, 0);
            else {
                $res = $_permiso->obtenerTipoPermiso($data['id']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    array_push($tabla[0], array(
                        "id" => $res->id,
                        "descripcion" => htmlspecialchars($res->descripcion),
                        "congoce" => $res->congoce,
                        "hora" => $res->hora,
                        "ley" => htmlspecialchars($res->ley),
                        "observacion" => htmlspecialchars($res->observacion),
                        "formato" => $res->formato,
                        "codigoerp" => $res->codigoerp,
                    ));
                }
            }
            return $tabla;
        }

        public function ingresarLogPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_permiso']) || !isset($data['id_usuario']) || !isset($data['observacion'])) array_push($tabla, 0);
            else {
                date_default_timezone_set("America/Santiago");
                $fecha = date('Y-m-d');
                $hora = date('H:i:s');
                $res = $_permiso->ingresarLogPermiso($data['id_permiso'], $data['id_usuario'], $data['observacion'], $fecha, $hora);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function permisosTrabajadorTipoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['fecha_inicio']) || !isset($data['fecha_termino']) || !isset($data['id_persona']) || !isset($data['id_tipo_permiso'])) array_push($tabla, 0);
            else {
                $res = $_permiso->permisosTrabajadorTipoPermiso($data['fecha_inicio'], $data['fecha_termino'], $data['id_persona'], $data['id_tipo_permiso']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "fecha_inicio" => $row['fecha_inicio'],
                            "fecha_termino" => $row['fecha_termino'],
                            "fecha_retorno" => $row['fecha_retorno'],
                            "cantidad" => $row['cantidad'],
                            "tipo" => htmlspecialchars($row['tipopermiso']),
                            "rut" => $row['rut'],
                            "nombre" => htmlspecialchars($row['nombre']),
                            "apellido" => htmlspecialchars($row['apellido']),
                            "observacion" => htmlspecialchars($row['observacion'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function configPermisoPersona($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_permiso->configPermisoPersona($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    array_push($tabla[0], array(
                        "tipo" => htmlspecialchars($res->tipopermiso),
                        "cantidad" => $res->cantidad,
                        "cantidadsistema" => $res->cantidadsistema,
                    ));
                }
            }
            return $tabla;
        }

        public function buscarCargoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_cargo'])) array_push($tabla, 0);
            else {
                $res = $_permiso->buscarCargoPermiso($data['id_cargo']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id_tipo_permiso" => $row['id_tipo_permiso'],
                            "tipopermiso" => htmlspecialchars($row['tipopermiso']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function horaExtraDigital($jsonData) {
            $_hora = new HoraExtra;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['pdfacepta'])) array_push($tabla, 0);
            else {
                $res = $_hora->horaExtraDigital($data['id'], $data['pdfacepta']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }

        public function modificarEstadoPermiso($jsonData) {
            $_permiso = new Permiso;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id']) || !isset($data['id_estado'])) array_push($tabla, 0);
            else {
                $res = $_permiso->modificarEstadoPermiso($data['id'], $data['id_estado']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (!$res || $res == 0) array_push($tabla, 0);
                else array_push($tabla, 1);
            }
            return $tabla;
        }
    }
?>