<?php
    include_once dirname(__FILE__) . '/../core/firmantes.php';

    class FirmanteController {

        public function obtenerFirmantesSucursal($jsonData) {
            $_firmante = new Firmante;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['idsucursal']) || !isset($data['iddepartamento'])) array_push($tabla, 0);
            else {
                if ($data['iddepartamento'] != 0) $res = $_firmante->obtenerFirmantesSucursalDepartamento($data['idsucursal'], $data['iddepartamento']);
                else $res = $_firmante->obtenerFirmantesSucursal($data['idsucursal']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "rut" => $row['rut'],
                            "email" => $row['email'],
                            "nombre" => htmlspecialchars($row['nombre'])
                        ));
                    }
                }
            }
            return $tabla;
        }
    }
?>