<?php
    include_once dirname(__FILE__) . '/../core/departamentos.php';

    class DepartamentoController {

        public function obtenerDepartamento($jsonData) {
            $_depto = new Departamento;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_depto->obtenerDepartamento($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "descripcion" => htmlspecialchars($row['descripcion'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerDepartamentoPrimario($jsonData) {
            $_depto = new Departamento;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_depto->obtenerDepartamentoPrimario($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "departamento" => htmlspecialchars($row['departamento']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                            "id_sucursal" =>$row['idsucursal']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerDepartamentoSucursal($jsonData) {
            $_depto = new Departamento;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_depto->obtenerDepartamentoSucursal($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "id_departamento" => $row['id_departamento'],
                            "departamento" => htmlspecialchars($row['departamento']),
                            "sucursal" => htmlspecialchars($row['sucursal']),
                            "primario" => $row['primario']
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function obtenerDeptoSucursal($jsonData) {
            $_depto = new Departamento;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_sucursal'])) array_push($tabla, 0);
            else {
                $res = $_depto->obtenerDeptoSucursal($data['id_sucursal']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "id" => $row['id'],
                            "descripcion" => htmlspecialchars($row['descripcion']),
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function listadoDepartamento() {
            $_depto = new Departamento;
            $tabla = [];

            $res = $_depto->listadoDepartamento();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }
    }
?>