<?php
    include_once dirname(__FILE__) .'/../core/cronjobs.php';

    class CronController {
        public function ingresarCronLector($idLector) {
            $_cronJob = new Cronjob;
            
            date_default_timezone_set("America/Santiago");
            $time = date_format(date_create("now"), "H:i:s");

            $res = $_cronJob->newReaderLog($idLector, $time);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else {
                if ($res) return array(
                    "result" => 1,
                    "content" => "Cron log inserted succesfully."
                );
                else return array(
                    "result" => 0,
                    "content" => "Error inserting cron log"
                );
            }
        }
        
        public function getReaderLogs($idLector) {
            $_cronJob = new Cronjob;

            $res = $_cronJob->getReaderLogs($idLector);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else return array(
                "result" => 1,
                "content" => $res
            );
        }
        
        public function deleteReaderLogs($idLector) {
            $_cronJob = new Cronjob;

            $res = $_cronJob->deleteReaderLogs($idLector);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else return array(
                "result" => 1,
                "content" => $res
            );
        }

        public function ingresarCronServidor($idServidor) {
            $_cronJob = new Cronjob;
            
            date_default_timezone_set("America/Santiago");
            $time = date_format(date_create("now"), "H:i:s");

            $res = $_cronJob->newServerLog($idServidor, $time);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else {
                if ($res) return array(
                    "result" => 1,
                    "content" => "Cron log inserted succesfully."
                );
                else return array(
                    "result" => 0,
                    "content" => "Error inserting cron log"
                );
            }
        }
        
        public function getServerLogs($idServidor) {
            $_cronJob = new Cronjob;

            $res = $_cronJob->getServerLogs($idServidor);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else return array(
                "result" => 1,
                "content" => $res
            );
        }
        
        public function deleteServerLogs($idServidor) {
            $_cronJob = new Cronjob;

            $res = $_cronJob->deleteServerLogs($idServidor);
            if (is_a($res, "PDOException")) return array(
                "result" => 0,
                "content" => json_encode($res)
            ); 
            else return array(
                "result" => 1,
                "content" => $res
            );
        }
    }
?>