<?php
    include_once dirname(__FILE__) . '/../core/cargos.php';

    class CargoController {

        public function mostrarCargoPersona($jsonData) {
            $_cargo = new Cargo;
            $tabla = [];

            $data = json_decode($jsonData, true);
            if (!isset($data['id_persona'])) array_push($tabla, 0);
            else {
                $res = $_cargo->mostrarCargoPersona($data['id_persona']);
                if (is_a($res, "PDOException")) array_push($tabla, 0);
                elseif (empty($res) || !$res) array_push($tabla, 0);
                else {
                    $tabla[0] = [];
                    foreach ($res as $row) {
                        array_push($tabla[0], array(
                            "idcargopersona" => $row['id'],
                            "id_cargo" => $row['id_cargo'],
                            "cargo" => utf8_encode($row['descripcion'])
                        ));
                    }
                }
            }
            return $tabla;
        }

        public function listadoCargo() {
            $_cargo = new Cargo;
            $tabla = [];

            $res = $_cargo->listadoCargo();
            if (is_a($res, "PDOException")) array_push($tabla, 0);
            elseif (empty($res) || !$res) array_push($tabla, 0);
            else {
                $tabla[0] = [];
                foreach ($res as $row) {
                    array_push($tabla[0], array(
                        "id" => $row['id'],
                        "descripcion" => htmlspecialchars($row['descripcion'])
                    ));
                }
            }
            return $tabla;
        }
    }
?>